/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.resolver.indices;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexRecoveryMonitoringDoc;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;

public class IndexRecoveryResolver
extends MonitoringIndexNameResolver.Timestamped<IndexRecoveryMonitoringDoc> {
    public static final String TYPE = "index_recovery";

    public IndexRecoveryResolver(MonitoredSystem id, Settings settings) {
        super(id, settings);
    }

    @Override
    public String type(IndexRecoveryMonitoringDoc document) {
        return TYPE;
    }

    @Override
    protected void buildXContent(IndexRecoveryMonitoringDoc document, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(TYPE);
        RecoveryResponse recovery = document.getRecoveryResponse();
        if (recovery != null) {
            builder.startArray("shards");
            Map shards = recovery.shardRecoveryStates();
            if (shards != null) {
                for (Map.Entry shard : shards.entrySet()) {
                    List indexShards = (List)shard.getValue();
                    if (indexShards == null) continue;
                    for (RecoveryState indexShard : indexShards) {
                        builder.startObject();
                        builder.field("index_name", (String)shard.getKey());
                        indexShard.toXContent(builder, params);
                        builder.endObject();
                    }
                }
            }
            builder.endArray();
        }
        builder.endObject();
    }

    static final class Fields {
        static final String INDEX_RECOVERY = "index_recovery";
        static final String SHARDS = "shards";
        static final String INDEX_NAME = "index_name";

        Fields() {
        }
    }
}

