/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.action.filter.SecurityActionFilter;
import org.elasticsearch.xpack.security.action.interceptor.BulkShardRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.FieldStatsRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.SearchRequestInterceptor;
import org.elasticsearch.xpack.security.action.interceptor.UpdateRequestInterceptor;
import org.elasticsearch.xpack.security.support.AbstractSecurityModule;

public class SecurityActionModule
extends AbstractSecurityModule.Node {
    public SecurityActionModule(Settings settings) {
        super(settings);
    }

    @Override
    protected void configureNode() {
        this.bind(SecurityActionFilter.class).asEagerSingleton();
        Multibinder multibinder = Multibinder.newSetBinder((Binder)this.binder(), RequestInterceptor.class);
        if (((Boolean)XPackSettings.DLS_FLS_ENABLED.get(this.settings)).booleanValue()) {
            multibinder.addBinding().to(SearchRequestInterceptor.class);
            multibinder.addBinding().to(UpdateRequestInterceptor.class);
            multibinder.addBinding().to(BulkShardRequestInterceptor.class);
            multibinder.addBinding().to(FieldStatsRequestInterceptor.class);
        }
    }
}

