/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.user.LogstashSystemUser;

public class NativeRealmMigrator {
    private final NativeUsersStore nativeUsersStore;
    private final XPackLicenseState licenseState;
    private final Logger logger;

    public NativeRealmMigrator(Settings settings, NativeUsersStore nativeUsersStore, XPackLicenseState licenseState) {
        this.nativeUsersStore = nativeUsersStore;
        this.licenseState = licenseState;
        this.logger = Loggers.getLogger(this.getClass(), (Settings)settings, (String[])new String[0]);
    }

    public void performUpgrade(@Nullable Version previousVersion, final ActionListener<Boolean> listener) {
        try {
            if (this.shouldDisableLogstashUser(previousVersion)) {
                this.logger.info("Upgrading security from version [{}] - new reserved user [{}] will default to disabled", (Object)previousVersion, (Object)"logstash_system");
                boolean clearCache = this.licenseState.isAuthAllowed();
                this.nativeUsersStore.ensureReservedUserIsDisabled("logstash_system", clearCache, new ActionListener<Void>(){

                    public void onResponse(Void aVoid) {
                        listener.onResponse((Object)true);
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            } else {
                listener.onResponse((Object)false);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private boolean shouldDisableLogstashUser(@Nullable Version previousVersion) {
        return previousVersion != null && previousVersion.before(LogstashSystemUser.DEFINED_SINCE);
    }
}

