/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.KeyConfig;

class PEMKeyConfig
extends KeyConfig {
    private final String keyPath;
    private final String keyPassword;
    private final String certPath;

    PEMKeyConfig(String keyPath, String keyPassword, String certChainPath) {
        this.keyPath = Objects.requireNonNull(keyPath, "key file must be specified");
        this.keyPassword = keyPassword;
        this.certPath = Objects.requireNonNull(certChainPath, "certificate must be specified");
    }

    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        char[] password = this.keyPassword == null ? new char[]{} : this.keyPassword.toCharArray();
        try {
            PrivateKey privateKey = this.readPrivateKey(CertUtils.resolvePath(this.keyPath, environment));
            Certificate[] certificateChain = CertUtils.readCertificates(Collections.singletonList(this.certPath), environment);
            X509ExtendedKeyManager x509ExtendedKeyManager = CertUtils.keyManager(certificateChain, privateKey, password);
            return x509ExtendedKeyManager;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a KeyManagerFactory", (Throwable)e, new Object[0]);
        }
        finally {
            if (password != null) {
                Arrays.fill(password, '\u0000');
            }
        }
    }

    /*
     * Loose catch block
     */
    private PrivateKey readPrivateKey(Path keyPath) throws Exception {
        char[] password = this.keyPassword == null ? null : this.keyPassword.toCharArray();
        try {
            try (BufferedReader reader = Files.newBufferedReader(keyPath, StandardCharsets.UTF_8);){
                PrivateKey privateKey = CertUtils.readPrivateKey(reader, () -> password);
                return privateKey;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (password != null) {
                Arrays.fill(password, '\u0000');
            }
        }
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            Certificate[] certificates = CertUtils.readCertificates(Collections.singletonList(this.certPath), environment);
            return CertUtils.trustManager(certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        ArrayList<Path> paths = new ArrayList<Path>(2);
        paths.add(CertUtils.resolvePath(this.keyPath, environment));
        paths.add(CertUtils.resolvePath(this.certPath, environment));
        return paths;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PEMKeyConfig that = (PEMKeyConfig)o;
        if (this.keyPath != null ? !this.keyPath.equals(that.keyPath) : that.keyPath != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals(that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        return this.certPath != null ? this.certPath.equals(that.certPath) : that.certPath == null;
    }

    @Override
    public int hashCode() {
        int result = this.keyPath != null ? this.keyPath.hashCode() : 0;
        result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = 31 * result + (this.certPath != null ? this.certPath.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "keyPath=[" + this.keyPath + "], certPaths=[" + this.certPath + "]";
    }
}

