/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.util.concurrent.BlockingQueue;
import java.util.stream.Stream;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.watcher.execution.WatchExecutor;

public class InternalWatchExecutor
implements WatchExecutor {
    public static final String THREAD_POOL_NAME = "watcher";
    private final ThreadPool threadPool;

    @Inject
    public InternalWatchExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public BlockingQueue<Runnable> queue() {
        return this.executor().getQueue();
    }

    @Override
    public Stream<Runnable> tasks() {
        return this.executor().getTasks();
    }

    @Override
    public long largestPoolSize() {
        return this.executor().getLargestPoolSize();
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor().execute(runnable);
    }

    private EsThreadPoolExecutor executor() {
        return (EsThreadPoolExecutor)this.threadPool.executor(THREAD_POOL_NAME);
    }
}

