/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.chain;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.transform.Transform;
import org.elasticsearch.xpack.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.transform.TransformRegistry;
import org.elasticsearch.xpack.watcher.transform.chain.ChainTransform;
import org.elasticsearch.xpack.watcher.transform.chain.ExecutableChainTransform;

public final class ChainTransformFactory
extends TransformFactory<ChainTransform, ChainTransform.Result, ExecutableChainTransform> {
    private final TransformRegistry registry;

    public ChainTransformFactory(Settings settings, TransformRegistry registry) {
        super(Loggers.getLogger(ExecutableChainTransform.class, (Settings)settings, (String[])new String[0]));
        this.registry = registry;
    }

    @Override
    public String type() {
        return "chain";
    }

    @Override
    public ChainTransform parseTransform(String watchId, XContentParser parser, boolean upgradeTransformSource) throws IOException {
        return ChainTransform.parse(watchId, parser, this.registry, upgradeTransformSource);
    }

    @Override
    public ExecutableChainTransform createExecutable(ChainTransform chainTransform) {
        ArrayList<ExecutableTransform> executables = new ArrayList<ExecutableTransform>();
        for (Transform transform : chainTransform.getTransforms()) {
            TransformFactory factory = this.registry.factory(transform.type());
            executables.add((ExecutableTransform)factory.createExecutable(transform));
        }
        return new ExecutableChainTransform(chainTransform, this.transformLogger, executables);
    }
}

