/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.search;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.script.Script;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.init.proxy.WatcherClientProxy;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateRequest;
import org.elasticsearch.xpack.watcher.support.search.WatcherSearchTemplateService;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.transform.search.SearchTransform;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableSearchTransform
extends ExecutableTransform<SearchTransform, SearchTransform.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    protected final WatcherClientProxy client;
    private final WatcherSearchTemplateService searchTemplateService;
    @Nullable
    protected final TimeValue timeout;

    public ExecutableSearchTransform(SearchTransform transform, Logger logger, WatcherClientProxy client, WatcherSearchTemplateService searchTemplateService, @Nullable TimeValue defaultTimeout) {
        super(transform, logger);
        this.client = client;
        this.searchTemplateService = searchTemplateService;
        this.timeout = transform.getTimeout() != null ? transform.getTimeout() : defaultTimeout;
    }

    @Override
    public SearchTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        WatcherSearchTemplateRequest request = null;
        try {
            Script template = ((SearchTransform)this.transform).getRequest().getOrCreateTemplate();
            BytesReference renderedTemplate = this.searchTemplateService.renderTemplate(template, ctx, payload);
            request = new WatcherSearchTemplateRequest(((SearchTransform)this.transform).getRequest(), renderedTemplate);
            SearchResponse resp = this.client.search(this.searchTemplateService.toSearchRequest(request), this.timeout);
            return new SearchTransform.Result(request, (Payload)new Payload.XContent((ToXContentObject)resp));
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to execute [{}] transform for [{}]", (Object)"search", (Object)ctx.id()), (Throwable)e);
            return new SearchTransform.Result(request, e);
        }
    }
}

