/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.schedule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.support.Exceptions;
import org.elasticsearch.xpack.watcher.trigger.schedule.CronnableSchedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.Schedule;
import org.elasticsearch.xpack.watcher.trigger.schedule.support.DayTimes;

public class HourlySchedule
extends CronnableSchedule {
    public static final String TYPE = "hourly";
    public static final int[] DEFAULT_MINUTES = new int[]{0};
    private final int[] minutes;

    HourlySchedule() {
        this(DEFAULT_MINUTES);
    }

    HourlySchedule(int ... minutes) {
        super(HourlySchedule.cron(minutes));
        this.minutes = minutes;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public int[] minutes() {
        return this.minutes;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("normalize", false) && this.minutes.length == 1) {
            builder.field(Parser.MINUTE_FIELD.getPreferredName(), this.minutes[0]);
        } else {
            builder.array(Parser.MINUTE_FIELD.getPreferredName(), this.minutes);
        }
        return builder.endObject();
    }

    public static Builder builder() {
        return new Builder();
    }

    static String cron(int[] minutes) {
        assert (minutes.length > 0) : "at least one minute must be defined";
        StringBuilder sb = new StringBuilder("0 ");
        for (int i = 0; i < minutes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            if (!HourlySchedule.validMinute(minutes[i])) {
                throw Exceptions.illegalArgument("invalid hourly minute [{}]. minute must be between 0 and 59 incl.", minutes[i]);
            }
            sb.append(minutes[i]);
        }
        return sb.append(" * * * ?").toString();
    }

    static boolean validMinute(int minute) {
        return minute >= 0 && minute < 60;
    }

    public static class Builder {
        private Set<Integer> minutes = new HashSet<Integer>();

        private Builder() {
        }

        public Builder minutes(int ... minutes) {
            for (int minute : minutes) {
                this.minutes.add(minute);
            }
            return this;
        }

        public HourlySchedule build() {
            return this.minutes.isEmpty() ? new HourlySchedule() : new HourlySchedule(CollectionUtils.toArray(this.minutes));
        }
    }

    public static class Parser
    implements Schedule.Parser<HourlySchedule> {
        static final ParseField MINUTE_FIELD = new ParseField("minute", new String[0]);

        @Override
        public String type() {
            return HourlySchedule.TYPE;
        }

        @Override
        public HourlySchedule parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            ArrayList<Integer> minutes = new ArrayList<Integer>();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) {
                    throw new ElasticsearchParseException("could not parse [{}] schedule. unexpected token [{}]", new Object[]{HourlySchedule.TYPE, token});
                }
                if (MINUTE_FIELD.match(currentFieldName)) {
                    if (token.isValue()) {
                        try {
                            minutes.add(DayTimes.parseMinuteValue(parser, token));
                            continue;
                        }
                        catch (ElasticsearchParseException pe) {
                            throw new ElasticsearchParseException("could not parse [{}] schedule. invalid value for [{}]", (Throwable)pe, new Object[]{HourlySchedule.TYPE, currentFieldName});
                        }
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            try {
                                minutes.add(DayTimes.parseMinuteValue(parser, token));
                            }
                            catch (ElasticsearchParseException pe) {
                                throw new ElasticsearchParseException("could not parse [{}] schedule. invalid value for [{}]", (Throwable)pe, new Object[]{HourlySchedule.TYPE, currentFieldName});
                            }
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("could not parse [{}] schedule. invalid value for [{}]. expected either string/value or an array of string/number values, but found [{}]", new Object[]{HourlySchedule.TYPE, currentFieldName, token});
                }
                throw new ElasticsearchParseException("could not parse [{}] schedule. unexpected field [{}]", new Object[]{HourlySchedule.TYPE, currentFieldName});
            }
            return minutes.isEmpty() ? new HourlySchedule() : new HourlySchedule(CollectionUtils.toArray(minutes));
        }
    }
}

