/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.agenda;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.agenda.Agenda;
import org.flowable.common.engine.impl.agenda.ExecuteFutureActionOperation;

public class WaitForAnyFutureToFinishOperation
implements Runnable {
    protected final Agenda agenda;
    protected final List<ExecuteFutureActionOperation<?>> futureOperations;
    protected final Duration timeout;

    public WaitForAnyFutureToFinishOperation(Agenda agenda, List<ExecuteFutureActionOperation<?>> futureOperations, Duration timeout) {
        this.agenda = agenda;
        this.futureOperations = futureOperations;
        if (timeout == null) {
            this.timeout = null;
        } else {
            if (timeout.isNegative() || timeout.isZero()) {
                throw new FlowableException("max wait timeout has to be positive. It was " + timeout);
            }
            this.timeout = timeout;
        }
    }

    @Override
    public void run() {
        block10: {
            CompletableFuture[] anyOfFutures = new CompletableFuture[this.futureOperations.size()];
            for (int i = 0; i < this.futureOperations.size(); ++i) {
                anyOfFutures[i] = this.futureOperations.get(i).getFuture();
            }
            try {
                CompletableFuture<Object> anyOfFuture = CompletableFuture.anyOf(anyOfFutures);
                if (this.timeout == null) {
                    anyOfFuture.get();
                    break block10;
                }
                try {
                    anyOfFuture.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    for (ExecuteFutureActionOperation<?> futureOperation : this.futureOperations) {
                        if (futureOperation.isDone()) continue;
                        futureOperation.getFuture().cancel(true);
                    }
                    throw new FlowableException("None of the available futures completed within the max timeout of " + this.timeout, (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new FlowableException("Future was interrupted", (Throwable)e);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        for (ExecuteFutureActionOperation<?> futureOperation : this.futureOperations) {
            if (futureOperation.isDone()) {
                this.agenda.planOperation(futureOperation);
                continue;
            }
            this.agenda.planFutureOperation(futureOperation.getFuture(), futureOperation.getAction());
        }
    }
}

