/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.api.lock.LockManager;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.db.AbstractSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ProcessDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final String PROCESS_DB_SCHEMA_LOCK_NAME = "processDbSchemaLock";

    public void schemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"7.1.0.2".equals(dbVersion)) {
                throw new FlowableWrongDbException("7.1.0.2", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        this.logger.debug("flowable db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        String selectSchemaVersionStatement = dbSqlSession.getDbSqlSessionFactory().mapStatement("org.flowable.common.engine.impl.persistence.entity.PropertyEntityImpl.selectPropertyValue");
        return (String)dbSqlSession.getSqlSession().selectOne(selectSchemaVersionStatement, (Object)"schema.version");
    }

    public void schemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.getProcessEngineConfiguration();
        if (processEngineConfiguration.isUseLockForDatabaseSchemaUpdate()) {
            LockManager lockManager = processEngineConfiguration.getManagementService().getLockManager(PROCESS_DB_SCHEMA_LOCK_NAME);
            lockManager.waitForLockRunAndRelease(processEngineConfiguration.getSchemaLockWaitTime(), () -> {
                this.schemaCreateInLock();
                return null;
            });
        } else {
            this.schemaCreateInLock();
        }
    }

    protected void schemaCreateInLock() {
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"7.1.0.2".equals(dbVersion)) {
                throw new FlowableWrongDbException("7.1.0.2", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void schemaDrop() {
        try {
            this.executeMandatorySchemaResource("drop", "engine");
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
                this.executeMandatorySchemaResource("drop", "history");
            }
        }
        catch (Exception e) {
            this.logger.info("Error dropping engine tables", (Throwable)e);
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String schemaUpdate() {
        LockManager lockManager;
        ProcessEngineConfigurationImpl processEngineConfiguration;
        PropertyEntity dbVersionProperty = null;
        String dbVersion = null;
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        int version6120Index = FlowableVersions.getFlowableVersionIndexForDbVersion((String)"6.1.2.0");
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        boolean isEngineTablePresent = this.isEngineTablePresent();
        if (isEngineTablePresent) {
            dbVersionProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntityImpl.class, "schema.version");
            dbVersion = dbVersionProperty.getValue();
        }
        if ((processEngineConfiguration = this.getProcessEngineConfiguration()).isUseLockForDatabaseSchemaUpdate()) {
            lockManager = processEngineConfiguration.getManagementService().getLockManager(PROCESS_DB_SCHEMA_LOCK_NAME);
            lockManager.waitForLock(processEngineConfiguration.getSchemaLockWaitTime());
        } else {
            lockManager = null;
        }
        try {
            if (isEngineTablePresent) {
                dbVersionProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntityImpl.class, "schema.version");
                dbVersion = dbVersionProperty.getValue();
                matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion((String)dbVersion);
                isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
            }
            boolean isHistoryTablePresent = this.isHistoryTablePresent();
            if (isUpgradeNeeded && matchingVersionIndex < version6120Index) {
                this.dbSchemaUpgradeUntil6120("engine", matchingVersionIndex, dbVersion);
                if (isHistoryTablePresent) {
                    this.dbSchemaUpgradeUntil6120("history", matchingVersionIndex, dbVersion);
                }
            }
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("7.1.0.2");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = (PropertyEntity)CommandContextUtil.getPropertyEntityManager().create();
                    dbHistoryProperty.setName("schema.history");
                    dbHistoryProperty.setValue("create(5.0)");
                    dbSqlSession.insert((Entity)dbHistoryProperty, processEngineConfiguration.getIdGenerator());
                } else {
                    dbHistoryProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = "upgrade(" + dbVersion + "->7.1.0.2)";
                dbHistoryProperty.setValue(dbHistoryValue);
                if (version6120Index > matchingVersionIndex) {
                    this.dbSchemaUpgrade("engine", version6120Index, dbVersion);
                } else {
                    this.dbSchemaUpgrade("engine", matchingVersionIndex, dbVersion);
                }
                feedback = "upgraded Flowable from " + dbVersion + " to 7.1.0.2";
            } else if (!isEngineTablePresent) {
                this.dbSchemaCreateEngine();
            }
            if (isHistoryTablePresent) {
                if (isUpgradeNeeded) {
                    if (version6120Index > matchingVersionIndex) {
                        this.dbSchemaUpgrade("history", version6120Index, dbVersion);
                    } else {
                        this.dbSchemaUpgrade("history", matchingVersionIndex, dbVersion);
                    }
                }
            } else if (dbSqlSession.getDbSqlSessionFactory().isDbHistoryUsed()) {
                this.dbSchemaCreateHistory();
            }
            String string = feedback;
            return string;
        }
        finally {
            if (lockManager != null) {
                lockManager.releaseLock();
            }
        }
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new FlowableException("Illegal format for version: " + versionString, (Throwable)nfe);
        }
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return CommandContextUtil.getProcessEngineConfiguration();
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/db/";
    }

    public String getContext() {
        return "bpmn";
    }
}

