/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.HistoryJobHandler;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncHistoryJobHandler
implements HistoryJobHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean isAsyncHistoryJsonGroupingEnabled;
    protected String jobType;

    public AbstractAsyncHistoryJobHandler(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public String getType() {
        return this.jobType;
    }

    @Override
    public void execute(HistoryJobEntity job, String configuration, CommandContext commandContext, JobServiceConfiguration jobServiceConfiguration) {
        block12: {
            JsonNode historyNode;
            block13: {
                ObjectMapper objectMapper = commandContext.getObjectMapper();
                if (job.getAdvancedJobHandlerConfigurationByteArrayRef() == null) break block12;
                try {
                    byte[] bytes = this.getJobBytes(job);
                    historyNode = objectMapper.readTree(bytes);
                }
                catch (Exception e) {
                    throw new FlowableException("Could not deserialize async history json for job (id=" + job.getId() + ")", (Throwable)e);
                }
                if (!this.isAsyncHistoryJsonGroupingEnabled() || !historyNode.isArray()) break block13;
                ArrayList<ObjectNode> failedNodes = null;
                FlowableException exception = null;
                ArrayNode arrayNode = (ArrayNode)historyNode;
                for (JsonNode jsonNode : arrayNode) {
                    try {
                        this.processHistoryJson(commandContext, job, jsonNode);
                    }
                    catch (Exception ex) {
                        if (failedNodes == null) {
                            failedNodes = new ArrayList<ObjectNode>();
                        }
                        failedNodes.add((ObjectNode)jsonNode);
                        exception = new FlowableException("Failed to process async history json. See suppressed exceptions.");
                        exception.addSuppressed(ex);
                    }
                }
                if (failedNodes == null || failedNodes.isEmpty()) break block12;
                AsyncHistorySession historySession = (AsyncHistorySession)commandContext.getSession(AsyncHistorySession.class);
                List<HistoryJobEntity> newHistoryJobs = historySession.getAsyncHistoryListener().historyDataGenerated(jobServiceConfiguration, failedNodes);
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                String exceptionStacktrace = stringWriter.toString();
                for (HistoryJobEntity historyJob : newHistoryJobs) {
                    historyJob.setExceptionMessage(exception.getMessage());
                    historyJob.setExceptionStacktrace(exceptionStacktrace);
                    if (job.getRetries() == 0) {
                        DeadLetterJobEntity deadLetterJob = jobServiceConfiguration.getJobManager().createDeadLetterJobFromHistoryJob(historyJob);
                        jobServiceConfiguration.getDeadLetterJobDataManager().insert(deadLetterJob);
                        jobServiceConfiguration.getHistoryJobEntityManager().deleteNoCascade(historyJob);
                        continue;
                    }
                    historyJob.setRetries(job.getRetries() - 1);
                }
                break block12;
            }
            try {
                this.processHistoryJson(commandContext, job, historyNode);
            }
            catch (AsyncHistoryJobNotApplicableException e) {
                throw e;
            }
            catch (Exception e) {
                if (!(e instanceof FlowableException) || e instanceof FlowableException && ((FlowableException)e).isLogged()) {
                    this.logger.warn("Could not execute history job", (Throwable)e);
                }
                throw new FlowableException("Failed to process async history json for job (id=" + job.getId() + ")", (Throwable)e);
            }
        }
    }

    protected byte[] getJobBytes(HistoryJobEntity job) {
        return job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes(job.getScopeType());
    }

    protected abstract void processHistoryJson(CommandContext var1, HistoryJobEntity var2, JsonNode var3);

    public boolean isAsyncHistoryJsonGroupingEnabled() {
        return this.isAsyncHistoryJsonGroupingEnabled;
    }

    public void setAsyncHistoryJsonGroupingEnabled(boolean isAsyncHistoryJsonGroupingEnabled) {
        this.isAsyncHistoryJsonGroupingEnabled = isAsyncHistoryJsonGroupingEnabled;
    }
}

