/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.aot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class BaseAutoDeployResourceContribution
implements BeanFactoryInitializationAotContribution {
    protected final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String locationPrefix;
    protected final Collection<String> locationSuffixes;

    public BaseAutoDeployResourceContribution(String locationPrefix, Collection<String> locationSuffixes) {
        this.locationPrefix = locationPrefix;
        this.locationSuffixes = locationSuffixes;
    }

    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        RuntimeHints runtimeHints = generationContext.getRuntimeHints();
        for (String locationSuffix : this.locationSuffixes) {
            String path = this.locationPrefix + locationSuffix;
            try {
                for (Resource resource : this.resolver.getResources(path)) {
                    ClassPathResource classPathResource = this.asClasspathResource(resource);
                    if (classPathResource == null || !classPathResource.exists()) continue;
                    this.logger.debug("Registering hints for {}", (Object)classPathResource);
                    this.applyToResource(classPathResource, runtimeHints);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to find resources for " + path, e);
            }
        }
    }

    protected void applyToResource(ClassPathResource resource, RuntimeHints hints) {
        hints.resources().registerResource((Resource)resource);
    }

    protected ClassPathResource asClasspathResource(Resource resource) {
        if (resource instanceof ClassPathResource) {
            return (ClassPathResource)resource;
        }
        try {
            this.logger.debug("Transforming {} to a classpath resource", (Object)resource);
            String marker = "jar!";
            String externalFormOfUrl = resource.getURL().toExternalForm();
            if (externalFormOfUrl.contains(marker)) {
                String rest = externalFormOfUrl.substring(externalFormOfUrl.lastIndexOf(marker) + marker.length());
                return new ClassPathResource(rest);
            }
            String classesSubstring = "classes/";
            int locationOfClassesInUrl = externalFormOfUrl.indexOf(classesSubstring);
            if (locationOfClassesInUrl != -1) {
                return new ClassPathResource(externalFormOfUrl.substring(locationOfClassesInUrl + classesSubstring.length()));
            }
            this.logger.error("Could not resolve {} as a classpath resource", (Object)resource);
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

