/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.aot.cmmn;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConverter;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.spring.boot.aot.BaseAutoDeployResourceContribution;
import org.flowable.spring.boot.cmmn.FlowableCmmnProperties;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;

public class FlowableCmmnAutoDeployBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    protected final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (!ClassUtils.isPresent((String)"org.flowable.cmmn.spring.SpringCmmnEngineConfiguration", (ClassLoader)beanFactory.getBeanClassLoader())) {
            return null;
        }
        if (!beanFactory.containsBean("cmmnEngineConfiguration")) {
            return null;
        }
        FlowableCmmnProperties properties = (FlowableCmmnProperties)beanFactory.getBeanProvider(FlowableCmmnProperties.class).getIfAvailable();
        if (properties == null || !properties.isDeployResources()) {
            return null;
        }
        List<String> locationSuffixes = properties.getResourceSuffixes();
        if (locationSuffixes.isEmpty()) {
            return null;
        }
        String locationPrefix = properties.getResourceLocation();
        if (locationPrefix.startsWith("classpath:") || locationPrefix.startsWith("classpath*:")) {
            return new CmmnAutoDeployResourceContribution(locationPrefix, locationSuffixes, beanFactory);
        }
        return null;
    }

    static class CmmnAutoDeployResourceContribution
    extends BaseAutoDeployResourceContribution {
        protected final ConfigurableListableBeanFactory beanFactory;

        public CmmnAutoDeployResourceContribution(String locationPrefix, Collection<String> locationSuffixes, ConfigurableListableBeanFactory beanFactory) {
            super(locationPrefix, locationSuffixes);
            this.beanFactory = beanFactory;
        }

        @Override
        protected void applyToResource(ClassPathResource resource, RuntimeHints hints) {
            super.applyToResource(resource, hints);
            CmmnXmlConverter cmmXmlConverter = new CmmnXmlConverter();
            CmmnModel cmmnModel = cmmXmlConverter.convertToCmmnModel(() -> {
                try {
                    return resource.getInputStream();
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to read resource " + resource, e);
                }
            }, false, false);
            List serviceTasks = cmmnModel.getPrimaryCase().findPlanItemDefinitionsOfType(ServiceTask.class);
            for (ServiceTask serviceTask : serviceTasks) {
                if (!"delegateExpression".equals(serviceTask.getImplementationType())) continue;
                String expression = serviceTask.getImplementation();
                String expressionWithoutDelimiters = expression.substring(2);
                String beanName = expressionWithoutDelimiters = expressionWithoutDelimiters.substring(0, expressionWithoutDelimiters.length() - 1);
                try {
                    BeanDefinition beanDefinition = this.beanFactory.getBeanDefinition(beanName);
                    String beanClassName = beanDefinition.getBeanClassName();
                    if (StringUtils.isNotEmpty((CharSequence)beanClassName)) {
                        hints.reflection().registerType(TypeReference.of((String)beanClassName), MemberCategory.values());
                        this.logger.debug("Registering hint for bean name [{}] for service task {} in {}", new Object[]{beanName, serviceTask.getId(), resource});
                        continue;
                    }
                    this.logger.debug("No bean class name for bean name [{}] for service task {} in {}", new Object[]{beanName, serviceTask.getId(), resource});
                }
                catch (Throwable throwable) {
                    this.logger.error("Couldn't find bean named [{}] for service task {} in {}", new Object[]{beanName, serviceTask.getId(), resource});
                }
            }
        }
    }
}

