/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.remote.task;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.job.TargetDocumentSpecs;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.util.StringUtils;
import org.jodconverter.remote.office.RemoteOfficeContext;
import org.jodconverter.remote.office.RequestConfig;
import org.jodconverter.remote.task.AbstractRemoteOfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteConversionTask
extends AbstractRemoteOfficeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteConversionTask.class);
    private static final String FILTER_DATA = "FilterData";
    private static final String FILTER_DATA_PREFIX_PARAM = "fd";
    private static final String LOAD_PROPERTIES_PREFIX_PARAM = "l";
    private static final String STORE_PROPERTIES_PREFIX_PARAM = "s";
    private final TargetDocumentSpecs target;

    public RemoteConversionTask(@NonNull SourceDocumentSpecs source, @NonNull TargetDocumentSpecs target) {
        super(source);
        this.target = target;
    }

    private void addPropertiesToBuilder(URIBuilder uriBuilder, String parameterPrefix, Map<String, Object> properties) {
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (FILTER_DATA.equalsIgnoreCase(key) && value instanceof Map) {
                    for (Map.Entry fdentry : ((Map)value).entrySet()) {
                        uriBuilder.addParameter(parameterPrefix + FILTER_DATA_PREFIX_PARAM + (String)fdentry.getKey(), fdentry.getValue().toString());
                    }
                    continue;
                }
                uriBuilder.addParameter(parameterPrefix + key, value.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NonNull OfficeContext context) throws OfficeException {
        LOGGER.info("Executing remote conversion task...");
        RemoteOfficeContext remoteContext = (RemoteOfficeContext)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            try {
                HttpEntity entity = MultipartEntityBuilder.create().addPart("data", (ContentBody)new FileBody(sourceFile)).build();
                RequestConfig requestConfig = remoteContext.getRequestConfig();
                URIBuilder uriBuilder = new URIBuilder(this.buildUrl(requestConfig.getUrl()));
                this.addPropertiesToBuilder(uriBuilder, LOAD_PROPERTIES_PREFIX_PARAM, Objects.requireNonNull(this.target.getFormat()).getLoadProperties());
                this.addPropertiesToBuilder(uriBuilder, STORE_PROPERTIES_PREFIX_PARAM, this.target.getFormat().getStoreProperties(Objects.requireNonNull(this.source.getFormat()).getInputFamily()));
                Executor.newInstance((HttpClient)remoteContext.getHttpClient()).execute(Request.Post((URI)uriBuilder.build()).connectTimeout(Math.toIntExact(requestConfig.getConnectTimeout())).socketTimeout(Math.toIntExact(requestConfig.getSocketTimeout())).body(entity)).saveContent(targetFile);
                this.target.onComplete(targetFile);
            }
            catch (Exception ex) {
                LOGGER.error("Remote conversion failed.", (Throwable)ex);
                OfficeException officeEx = new OfficeException("Remote conversion failed", (Throwable)ex);
                this.target.onFailure(targetFile, (Exception)officeEx);
                throw officeEx;
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private String buildUrl(String connectionUrl) {
        return StringUtils.appendIfMissing((String)connectionUrl, (String)"/") + Objects.requireNonNull(this.target.getFormat()).getExtension();
    }

    @Override
    public @NonNull String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{source=" + this.source + ", target=" + this.target + '}';
    }
}

