/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.features.jpa.builder.MethodSqlBuilder;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.features.jpa.builder.impl.ComputeSqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.LogicalSqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.OrderBySqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.PropertySqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.SelectOrDeleteSqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.SortDirectionSqlBuilder;
import org.apache.ibatis.features.jpa.builder.impl.WhereSqlBuilder;

public class SqlBuilderChain {
    private static final List<MethodSqlBuilder> builders = new ArrayList<MethodSqlBuilder>();
    private int chainIndex = 0;
    private final int chainLength = builders.size();

    public void build(String keyWord, SqlContext sqlContext) {
        if (this.chainIndex == this.chainLength) {
            return;
        }
        MethodSqlBuilder builder = builders.get(this.chainIndex++);
        builder.build(keyWord, sqlContext, this);
    }

    public void reset() {
        this.chainIndex = 0;
    }

    static {
        builders.add(new SelectOrDeleteSqlBuilder());
        builders.add(new WhereSqlBuilder());
        builders.add(new PropertySqlBuilder());
        builders.add(new ComputeSqlBuilder());
        builders.add(new LogicalSqlBuilder());
        builders.add(new OrderBySqlBuilder());
        builders.add(new SortDirectionSqlBuilder());
    }
}

