/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.features.jpa.builder.MethodSqlBuilder;
import org.apache.ibatis.features.jpa.builder.SqlBuilderChain;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.utils.StringUtils;

public class NumberSqlBuilder
implements MethodSqlBuilder {
    private static final Map<String, Integer> LIMIT_MAP = new HashMap<String, Integer>();

    @Override
    public void build(String keyWord, SqlContext sqlContext, SqlBuilderChain builderChain) {
        for (Map.Entry<String, Integer> entry : LIMIT_MAP.entrySet()) {
            if (!StringUtils.startsWithIgnoreCase(keyWord, entry.getKey())) continue;
            if (StringUtils.equalsIgnoreCase(keyWord, entry.getKey())) {
                sqlContext.setLimitSegment(" limit ".concat(String.valueOf(entry.getValue())));
                continue;
            }
            if (!StringUtils.isNumberic(keyWord = keyWord.substring(entry.getKey().length()))) continue;
            sqlContext.setLimitSegment(" limit ".concat(keyWord));
        }
    }

    static {
        LIMIT_MAP.put("first", 1);
        LIMIT_MAP.put("one", 1);
        LIMIT_MAP.put("top", 1);
    }
}

