/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.features.jpa.builder.MethodSqlBuilder;
import org.apache.ibatis.features.jpa.builder.SqlBuilderChain;
import org.apache.ibatis.features.jpa.builder.SqlContext;
import org.apache.ibatis.features.jpa.builder.impl.NumberSqlBuilder;
import org.apache.ibatis.utils.StringUtils;

public class SelectOrDeleteSqlBuilder
implements MethodSqlBuilder {
    private static final Map<String, String> dmlMapping = new HashMap<String, String>();
    private static final String select = "select";
    private static final String delete = "delete";
    private NumberSqlBuilder numberSqlBuilder = new NumberSqlBuilder();

    @Override
    public void build(String keyWord, SqlContext sqlContext, SqlBuilderChain builderChain) {
        String director = StringUtils.nextHumpWord(keyWord);
        String operator = dmlMapping.get(director);
        if (!StringUtils.isEmpty(operator)) {
            StringBuilder sql = new StringBuilder();
            switch (operator) {
                case "delete": {
                    sql.append(delete).append(" from ").append(sqlContext.getTable().getName());
                    sqlContext.setFlag(delete);
                    break;
                }
                case "select": {
                    sql.append(select);
                    sqlContext.setFlag(select);
                    keyWord = keyWord.substring(director.length());
                    if (!StringUtils.isEmpty(keyWord)) {
                        if (StringUtils.startsWithIgnoreCase(keyWord, "distinct")) {
                            sql.append(" distinct ");
                            keyWord = keyWord.substring("distinct".length());
                        }
                        if (!StringUtils.isEmpty(keyWord)) {
                            this.numberSqlBuilder.build(keyWord, sqlContext, builderChain);
                        }
                    }
                    sql.append(" ").append(sqlContext.getTable().getAllColumns()).append(" from ").append(sqlContext.getTable().getName());
                }
            }
            sqlContext.append(sql.toString());
        } else {
            builderChain.build(keyWord, sqlContext);
        }
    }

    static {
        dmlMapping.put(select, select);
        dmlMapping.put("find", select);
        dmlMapping.put("get", select);
        dmlMapping.put("read", select);
        dmlMapping.put("query", select);
        dmlMapping.put("load", select);
        dmlMapping.put("count", select);
        dmlMapping.put(delete, delete);
        dmlMapping.put("del", delete);
        dmlMapping.put("remove", delete);
    }
}

