/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.ddl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.features.jpa.ddl.DBType;
import org.apache.ibatis.features.jpa.ddl.DDLGenerator;
import org.apache.ibatis.features.jpa.ddl.DDLGeneratorFactory;
import org.apache.ibatis.utils.CollectionUtils;
import org.apache.ibatis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaExport {
    private static final Logger logger = LoggerFactory.getLogger(SchemaExport.class);

    public void export(DataSource dataSource, boolean showScript, boolean execute) {
        if (!showScript && !execute) {
            return;
        }
        logger.info("checking database ....");
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            DDLGenerator generator = DDLGeneratorFactory.getInstance().getDDLGenerator(this.checkDBType(connection));
            List<String> sqls = generator.generateDDL(connection);
            if (CollectionUtils.isEmpty(sqls)) {
                logger.info(" checking database complete !");
                return;
            }
            for (String sql : sqls) {
                if (showScript) {
                    logger.warn(sql);
                }
                if (!execute) continue;
                logger.warn("execute sql : {}", (Object)sql);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info(" checking database complete !");
    }

    public DBType checkDBType(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String url = meta.getURL();
        if (!StringUtils.isEmpty(url)) {
            if ((url = url.toLowerCase()).contains("mysql")) {
                return DBType.MYSQL;
            }
            if (url.contains("db2")) {
                return DBType.DB2;
            }
            if (url.contains("oracle")) {
                return DBType.ORACLE;
            }
            if (url.contains("sqlserver")) {
                return DBType.SQL_SERVER;
            }
            if (url.contains("sybase")) {
                return DBType.SYBASE;
            }
            if (url.contains("postgresql")) {
                return DBType.PostgreSQL;
            }
        }
        throw new RuntimeException(" Can not detect database type !");
    }
}

