/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.features.jpa.domain.Sort;
import org.apache.ibatis.features.jpa.generator.EntitySqlDispatcher;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.utils.StringUtils;

public final class Example<T> {
    private String orderByClause;
    private boolean distinct;
    private boolean exists;
    private boolean notNull;
    private Set<String> selectColumns;
    private List<Criteria> oredCriteria;
    private Class<T> entityClass;
    private MetaDataParser dataParser;
    private String tableName;
    private Sort sort;

    public Example(Class<T> entityClass) {
        this(entityClass, true);
    }

    public Example(Class<T> entityClass, boolean exists) {
        this(entityClass, exists, false);
    }

    public Example(Class<T> entityClass, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.oredCriteria = new ArrayList<Criteria>();
        this.entityClass = entityClass;
        this.dataParser = EntitySqlDispatcher.getInstance().getMetaDataParser(entityClass);
        if (this.dataParser == null) {
            throw new IllegalArgumentException("Unknow entity class ".concat(String.valueOf(entityClass)));
        }
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public void orderBy(Sort.Direction direction, String ... properties) {
        this.sort = Sort.by(direction, properties);
        this.orderByClause = this.sort.toSql(this.dataParser.getTable());
    }

    public Set<String> getSelectColumns() {
        return this.selectColumns;
    }

    public Example selectProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            Table table = this.dataParser.getTable();
            for (String property : properties) {
                String column = table.getColumnByProperty(property);
                if (StringUtils.isEmpty(column)) continue;
                this.selectColumns.add(property);
            }
        }
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<Criteria> getOredCriteria() {
        return this.oredCriteria;
    }

    public void or(Criteria criteria) {
        this.oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = this.createCriteriaInternal();
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = this.createCriteriaInternal();
        if (this.oredCriteria.size() == 0) {
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.dataParser.getTable(), this.exists, this.notNull);
        return criteria;
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static class Criterion {
        private String condition;
        private Object value;
        private Object secondValue;
        private boolean noValue;
        private boolean singleValue;
        private boolean betweenValue;
        private boolean listValue;
        private String typeHandler;

        protected Criterion(String condition) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof Collection) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }
    }

    public static class Criteria
    extends GeneratedCriteria {
        protected Criteria(Table table, boolean exists, boolean notNull) {
            super(table, exists, notNull);
        }
    }

    protected static abstract class GeneratedCriteria
    extends TableColumnMapping {
        protected List<Criterion> criteria;
        protected boolean exists;
        protected boolean notNull;

        protected GeneratedCriteria(Table table, boolean exists, boolean notNull) {
            super(table);
            this.exists = exists;
            this.notNull = notNull;
            this.criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return this.criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return this.criteria;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new RuntimeException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new RuntimeException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIsNull(String property) {
            this.addCriterion(this.getColumnByProperty(property) + " is null");
            return (Criteria)this;
        }

        public Criteria andIsNotNull(String property) {
            this.addCriterion(this.getColumnByProperty(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria andEqualTo(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " =", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andNotEqualTo(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " <>", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThan(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " >", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andGreaterThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " >=", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andLessThan(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " <", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andLessThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.getColumnByProperty(property) + " <=", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andIn(String property, Iterable values) {
            this.addCriterion(this.getColumnByProperty(property) + " in", values, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andNotIn(String property, Iterable values) {
            this.addCriterion(this.getColumnByProperty(property) + " not in", values, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.getColumnByProperty(property) + " between", value1, value2, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andNotBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.getColumnByProperty(property) + " not between", value1, value2, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andLike(String property, String value) {
            this.addCriterion(this.getColumnByProperty(property) + "  like", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andNotLike(String property, String value) {
            this.addCriterion(this.getColumnByProperty(property) + "  not like", value, this.getExistsProperty(property));
            return (Criteria)this;
        }

        public Criteria andCondition(String condition) {
            this.addCriterion(condition);
            return (Criteria)this;
        }

        public Criteria andCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value));
            return (Criteria)this;
        }

        @Deprecated
        public Criteria andCondition(String condition, Object value, String typeHandler) {
            this.criteria.add(new Criterion(condition, value, typeHandler));
            return (Criteria)this;
        }

        @Deprecated
        public Criteria andCondition(String condition, Object value, Class<? extends TypeHandler> typeHandler) {
            this.criteria.add(new Criterion(condition, value, typeHandler.getCanonicalName()));
            return (Criteria)this;
        }

        public Criteria andEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = SystemMetaObject.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (!this.table.propertyExists(property) || (value = metaObject.getValue(property)) == null) continue;
                this.andEqualTo(property, value);
            }
            return (Criteria)this;
        }
    }

    static abstract class TableColumnMapping {
        Table table;

        TableColumnMapping(Table table) {
            this.table = table;
        }

        String getColumnByProperty(String property) {
            String column = this.table.getColumnByProperty(property);
            if (StringUtils.isEmpty(column)) {
                throw new IllegalArgumentException("Unknown property ".concat(property).concat(" for entity ").concat(String.valueOf(this.table.getEntity())));
            }
            return column;
        }

        String getExistsProperty(String property) {
            if (this.table.propertyExists(property)) {
                return property;
            }
            return null;
        }
    }
}

