/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.domain;

import java.util.Optional;
import org.apache.ibatis.features.jpa.domain.Sort;
import org.apache.ibatis.features.jpa.domain.Unpaged;
import org.apache.ibatis.utils.Assert;

public interface Pageable {
    public static Pageable unpaged() {
        return Unpaged.INSTANCE;
    }

    default public boolean isPaged() {
        return true;
    }

    default public boolean isUnpaged() {
        return !this.isPaged();
    }

    public int getPageNumber();

    public int getPageSize();

    public long getOffset();

    public Sort getSort();

    default public Sort getSortOr(Sort sort) {
        Assert.notNull(sort, "Fallback Sort must not be null!");
        return this.getSort().isSorted() ? this.getSort() : sort;
    }

    public Pageable next();

    public Pageable previousOrFirst();

    public Pageable first();

    public boolean hasPrevious();

    default public Optional<Pageable> toOptional() {
        return this.isUnpaged() ? Optional.empty() : Optional.of(this);
    }
}

