/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.session.Configuration;

public class EntitySqlDispatcher {
    private static final Map<Class, MetaDataParser> metaDataParserMap = new ConcurrentHashMap<Class, MetaDataParser>();
    private static final Map<String, MetaDataParser> namespaceDataParserMap = new ConcurrentHashMap<String, MetaDataParser>();
    private static final EntitySqlDispatcher instance = new EntitySqlDispatcher();

    private EntitySqlDispatcher() {
    }

    public static EntitySqlDispatcher getInstance() {
        return instance;
    }

    public MetaDataParser parseEntity(Class clazz, Class idClass, Configuration configuration, String mapper) {
        MetaDataParser metaDataParser = this.getMetaDataParser(clazz);
        if (metaDataParser == null) {
            metaDataParser = new MetaDataParser(clazz, idClass, configuration, mapper);
            metaDataParser.parse();
            this.addMetaDataParser(metaDataParser);
        }
        return metaDataParser;
    }

    public MetaDataParser getMetaDataParser(Class clazz) {
        return metaDataParserMap.get(clazz);
    }

    public MetaDataParser getMetaDataParserByNamespace(String namespace) {
        return namespaceDataParserMap.get(namespace);
    }

    public Set<Class> getEntities() {
        return Collections.unmodifiableSet(metaDataParserMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMetaDataParser(MetaDataParser parser) {
        Map<Object, MetaDataParser> map = metaDataParserMap;
        synchronized (map) {
            metaDataParserMap.put(parser.getEntityClass(), parser);
        }
        map = namespaceDataParserMap;
        synchronized (map) {
            namespaceDataParserMap.put(parser.getMapper(), parser);
        }
    }
}

