/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.ibatis.features.jpa.annotation.Column;
import org.apache.ibatis.features.jpa.annotation.Entity;
import org.apache.ibatis.features.jpa.annotation.Id;
import org.apache.ibatis.features.jpa.annotation.Index;
import org.apache.ibatis.features.jpa.meta.Table;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.utils.AnnotationUtils;
import org.apache.ibatis.utils.ReflectionUtils;
import org.apache.ibatis.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataParser {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataParser.class);
    public static final String DEFAULT_RESULT_MAP = "default";
    private Class entityClass;
    private Class idClass;
    private Table table;
    private String resultMap;
    private Configuration configuration;
    private String mapper;

    public MetaDataParser(Class entityClass, Class idClass, Configuration configuration, String mapper) {
        this.entityClass = entityClass;
        this.configuration = configuration;
        this.idClass = idClass;
        this.mapper = mapper;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public synchronized void parse() {
        this.table = new Table();
        org.apache.ibatis.features.jpa.annotation.Table tableAnno = AnnotationUtils.getAnnotation(this.entityClass, org.apache.ibatis.features.jpa.annotation.Table.class);
        Entity entity = AnnotationUtils.getAnnotation(this.entityClass, Entity.class);
        if (tableAnno == null && entity == null) {
            throw new IllegalArgumentException("Class " + this.entityClass.getName() + " is not a entity class !");
        }
        this.table.setEntity(this.entityClass);
        if (tableAnno != null) {
            this.table.setName(tableAnno.name());
            this.table.setCatalog(tableAnno.catalog());
            this.table.setSchema(tableAnno.schema());
            Index[] indices = tableAnno.indexes();
            if (indices != null && indices.length > 0) {
                ArrayList<org.apache.ibatis.features.jpa.meta.Index> indexList = new ArrayList<org.apache.ibatis.features.jpa.meta.Index>(indices.length);
                for (Index index : indices) {
                    indexList.add(new org.apache.ibatis.features.jpa.meta.Index(index));
                }
                this.table.setIndexes(indexList);
            }
        } else {
            this.table.setName(StringUtils.humpToUnderScore(this.entityClass.getSimpleName()));
        }
        ArrayList<org.apache.ibatis.features.jpa.meta.Column> idMappings = new ArrayList<org.apache.ibatis.features.jpa.meta.Column>();
        ArrayList<org.apache.ibatis.features.jpa.meta.Column> columnMappings = new ArrayList<org.apache.ibatis.features.jpa.meta.Column>();
        ReflectionUtils.doWithFields(this.entityClass, field -> {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
                logger.info("ignoring static or final field : {}", (Object)field.getName());
                return;
            }
            Id id = AnnotationUtils.getAnnotation(field, Id.class);
            Column columnAnno = AnnotationUtils.getAnnotation(field, Column.class);
            if (id == null && columnAnno == null) {
                logger.info("field {} on class {} doesn't has @Id or @Column annotation, ignore ", (Object)field.getName(), (Object)this.entityClass.getName());
                return;
            }
            org.apache.ibatis.features.jpa.meta.Column column = new org.apache.ibatis.features.jpa.meta.Column(columnAnno, id, field);
            if (column.isId()) {
                idMappings.add(column);
            } else {
                columnMappings.add(column);
            }
        });
        this.table.setColumns(columnMappings);
        this.table.setIdColumns(idMappings);
        this.table.afterPropertiesSet();
        this.resultMap = this.table.toResultMapXml(DEFAULT_RESULT_MAP);
    }

    public String getResultMapString() {
        return this.resultMap;
    }

    public Table getTable() {
        return this.table;
    }

    public Class getIdClass() {
        return this.idClass;
    }

    public String getMapper() {
        return this.mapper;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

