/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.generator.impl;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.features.jpa.generator.MetaDataParser;
import org.apache.ibatis.features.jpa.generator.impl.AbstractSqlGenerator;
import org.apache.ibatis.features.jpa.meta.Column;
import org.apache.ibatis.features.jpa.meta.Table;

public class SaveSqlGeneratorImpl
extends AbstractSqlGenerator {
    @Override
    public String generatorSql(MetaDataParser dataParser, Map<String, Object> params) {
        Column id = dataParser.getTable().getSingleIdColumn();
        String sql = this.generate(dataParser, !this.useGenerateKeys());
        if (this.useGenerateKeys()) {
            return this.insert(this.getMethod(params), dataParser.getEntityClass().getName(), id.getProperty(), id.getColumn(), "true", sql);
        }
        return this.insert(this.getMethod(params), dataParser.getEntityClass().getName(), null, null, null, sql);
    }

    boolean useGenerateKeys() {
        return false;
    }

    boolean includeNull() {
        return true;
    }

    public String generate(MetaDataParser dataParser, boolean includeId) {
        Table table = dataParser.getTable();
        StringBuilder builder = new StringBuilder();
        builder.append(" insert into ").append(table.getName()).append(" ");
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        List<Column> columnList = table.getColumns(includeId);
        if (!this.includeNull()) {
            table.getColumns(!this.useGenerateKeys()).forEach(column -> {
                columns.append(this.ifNotNull(column.getProperty(), column.getColumn() + ","));
                values.append(this.ifNotNull(column.getProperty(), "#{" + column.getProperty() + "},"));
            });
        } else {
            for (Column column2 : columnList) {
                columns.append(column2.getColumn()).append(",");
                values.append("#{").append(column2.getProperty()).append("},");
            }
        }
        builder.append(this.trim("(", ")", ",", columns.toString())).append(" values ").append(this.trim("(", ")", ",", values.toString())).toString();
        return builder.toString();
    }
}

