/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.ibatis.features.jpa.annotation.Id;
import org.apache.ibatis.features.jpa.meta.JdbcTypeConverter;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.utils.StringUtils;

public final class Column {
    private String table;
    private boolean isId;
    private String property;
    private String column;
    private String javaType;
    private Class javaTypeClass;
    private String type;
    private boolean nullable = true;
    private boolean unique = false;
    private String columnDefinition;
    private int precision;
    private int scale;
    private String defaultValue;
    private int length = 255;

    public Column() {
    }

    public Column(Id id, Field field) {
        this(null, id, field);
    }

    public Column(org.apache.ibatis.features.jpa.annotation.Column column, Id id, Field field) {
        this.property = field.getName();
        this.javaType = field.getType().getName();
        this.javaTypeClass = field.getType();
        boolean bl = this.isId = id != null;
        if (column != null) {
            this.column = column.name();
            this.columnDefinition = column.columnDefinition();
            this.unique = column.unique();
            this.nullable = column.nullable();
            this.table = column.table();
            this.length = column.length();
            this.type = column.type();
            this.scale = column.scale();
            this.precision = column.precision();
            this.defaultValue = column.defaultValue();
        }
        if (StringUtils.isEmpty(this.column)) {
            this.column = StringUtils.humpToUnderScore(this.property);
        }
        if (StringUtils.isEmpty(this.type)) {
            this.type = JdbcTypeConverter.toJdbcType(field.getType(), this.length);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Class getJavaTypeClass() {
        return this.javaTypeClass;
    }

    public void setJavaTypeClass(Class javaTypeClass) {
        this.javaTypeClass = javaTypeClass;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.columnDefinition = columnDefinition;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ResultMapping toResultMapping(Configuration configuration, String resultMapId) {
        ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
        if (this.isId()) {
            flags.add(ResultFlag.ID);
        }
        return new ResultMapping.Builder(configuration, this.getProperty(), this.getColumn(), this.getJavaTypeClass()).nestedResultMapId(resultMapId).flags(flags).build();
    }

    public String toResultMappingXml() {
        StringBuilder builder = new StringBuilder();
        String tag = "result";
        if (this.isId()) {
            tag = "id";
        }
        builder.append("<").append(tag).append(" column=\"").append(this.getColumn()).append("\" property=\"").append(this.getProperty()).append("\" />");
        return builder.toString();
    }
}

