/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.features.jpa.meta.Column;
import org.apache.ibatis.features.jpa.meta.Index;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.utils.CollectionUtils;

public final class Table {
    public static final String ALL_COLUMNS = "all_columns";
    public static final String ALL_COLUMNS_UPPERCASE = "all_columns".toUpperCase();
    private String name;
    private String catalog;
    private Class entity;
    private String schema;
    private List<Index> indexes;
    private List<Column> columns;
    private List<Column> idColumns;
    private List<SqlSegment> sqlSegments = new ArrayList<SqlSegment>();
    private Map<String, SqlSegment> sqlSegmentsMap;
    private Map<String, String> propertyColumnMap = new HashMap<String, String>();
    private Map<String, String> columnPropertyMap = new HashMap<String, String>();

    public String getColumnByProperty(String property) {
        return this.propertyColumnMap.get(property);
    }

    public boolean propertyExists(String property) {
        return this.propertyColumnMap.containsKey(property);
    }

    public String getPropertyByColumn(String column) {
        return this.columnPropertyMap.get(column);
    }

    public boolean columnExists(String column) {
        return this.columnPropertyMap.containsKey(column);
    }

    public List<Column> getColumns(boolean withId) {
        ArrayList<Column> columnList = new ArrayList<Column>(this.columns);
        if (withId) {
            columnList.addAll(0, this.idColumns);
        }
        return Collections.unmodifiableList(columnList);
    }

    public Column getSingleIdColumn() {
        if (this.idColumns.size() > 1) {
            throw new UnsupportedOperationException("More than one primary keys found ! " + this.entity.getName());
        }
        return this.idColumns.get(0);
    }

    public Class getEntity() {
        return this.entity;
    }

    public void setEntity(Class entity) {
        this.entity = entity;
    }

    public List<Column> getIdColumns() {
        return Collections.unmodifiableList(this.idColumns);
    }

    public void setIdColumns(List<Column> idColumns) {
        this.idColumns = idColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public List<Index> getIndexes() {
        return Collections.unmodifiableList(this.indexes);
    }

    public void setIndexes(List<Index> indexes) {
        this.indexes = indexes;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public List<SqlSegment> getSqlSegments() {
        return Collections.unmodifiableList(this.sqlSegments);
    }

    public void setSqlSegments(List<SqlSegment> sqlSegments) {
        this.sqlSegments = sqlSegments;
    }

    public String getAllColumns() {
        return this.sqlSegmentsMap.get(ALL_COLUMNS).getSql();
    }

    public synchronized void afterPropertiesSet() {
        StringBuilder builder = new StringBuilder();
        if (!CollectionUtils.isEmpty(this.idColumns)) {
            this.idColumns.forEach(column -> builder.append(" ").append(column.getColumn()).append(","));
        }
        if (!CollectionUtils.isEmpty(this.columns)) {
            this.columns.forEach(column -> builder.append(" ").append(column.getColumn()).append(","));
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        this.sqlSegments.add(new SqlSegment(ALL_COLUMNS, builder.toString()));
        this.sqlSegments.add(new SqlSegment(ALL_COLUMNS_UPPERCASE, builder.toString()));
        this.sqlSegmentsMap = this.sqlSegments.stream().collect(Collectors.toMap(SqlSegment::getId, s -> s));
        this.getColumns(true).forEach(column -> {
            this.propertyColumnMap.put(column.getProperty(), column.getColumn());
            this.columnPropertyMap.put(column.getColumn(), column.getProperty());
        });
    }

    public ResultMap toResultMap(Configuration configuration, String resultMapId) {
        ArrayList<ResultMapping> columnMappings = new ArrayList<ResultMapping>(this.columns.size());
        this.columns.forEach(column -> columnMappings.add(column.toResultMapping(configuration, resultMapId)));
        this.idColumns.forEach(column -> columnMappings.add(column.toResultMapping(configuration, resultMapId)));
        return new ResultMap.Builder(configuration, resultMapId, this.entity, columnMappings).build();
    }

    public String toResultMapXml(String resultMapId) {
        StringBuilder builder = new StringBuilder();
        builder.append("<resultMap id=\"").append(resultMapId).append("\" type=\"").append(this.getEntity().getName()).append("\" > \n ");
        this.getColumns(true).forEach(column -> builder.append(column.toResultMappingXml()).append(" \n "));
        return builder.append("</resultMap>").toString();
    }

    public static class SqlSegment {
        private String id;
        private String sql;

        public SqlSegment() {
        }

        public SqlSegment(String id, String sql) {
            this.id = id;
            this.sql = sql;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String toXml() {
            return "<sql id=\"" + this.id + "\" > \n " + this.sql + " \n " + "</sql>";
        }
    }
}

