/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.features.jpa.plugins.pagination.dialect;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.ibatis.features.jpa.plugins.pagination.PageException;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.AbstractDialect;
import org.apache.ibatis.features.jpa.plugins.pagination.dialect.MySqlDialect;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.utils.StringUtils;

public class PageAutoDialect {
    private static Map<String, Class<?>> dialectAliasMap = new HashMap();
    private boolean autoDialect = true;
    private boolean closeConn = true;
    private Properties properties;
    private Map<String, AbstractDialect> urlDialectMap = new ConcurrentHashMap<String, AbstractDialect>();
    private ReentrantLock lock = new ReentrantLock();
    private AbstractDialect delegate;
    private ThreadLocal<AbstractDialect> dialectThreadLocal = new ThreadLocal();

    public void initDelegateDialect(MappedStatement ms) {
        if (this.delegate == null) {
            if (this.autoDialect) {
                this.delegate = this.getDialect(ms);
            } else {
                this.dialectThreadLocal.set(this.getDialect(ms));
            }
        }
    }

    public AbstractDialect getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        return this.dialectThreadLocal.get();
    }

    public void clearDelegate() {
        this.dialectThreadLocal.remove();
    }

    private String fromJdbcUrl(String jdbcUrl) {
        for (String dialect : dialectAliasMap.keySet()) {
            if (jdbcUrl.indexOf(":" + dialect + ":") == -1) continue;
            return dialect;
        }
        return null;
    }

    private Class resloveDialectClass(String className) throws Exception {
        if (dialectAliasMap.containsKey(className.toLowerCase())) {
            return dialectAliasMap.get(className.toLowerCase());
        }
        return Class.forName(className);
    }

    private AbstractDialect initDialect(String dialectClass, Properties properties) {
        AbstractDialect dialect;
        if (StringUtils.isEmpty(dialectClass)) {
            throw new PageException("\u4f7f\u7528 PageHelper \u5206\u9875\u63d2\u4ef6\u65f6\uff0c\u5fc5\u987b\u8bbe\u7f6e helper \u5c5e\u6027");
        }
        try {
            Class sqlDialectClass = this.resloveDialectClass(dialectClass);
            if (!AbstractDialect.class.isAssignableFrom(sqlDialectClass)) {
                throw new PageException("\u4f7f\u7528 PageHelper \u65f6\uff0c\u65b9\u8a00\u5fc5\u987b\u662f\u5b9e\u73b0 " + AbstractDialect.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5b9e\u73b0\u7c7b!");
            }
            dialect = (AbstractDialect)sqlDialectClass.newInstance();
        }
        catch (Exception e) {
            throw new PageException("\u521d\u59cb\u5316 helper [" + dialectClass + "]\u65f6\u51fa\u9519:" + e.getMessage(), e);
        }
        return dialect;
    }

    private String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new PageException(e);
        }
        finally {
            if (conn != null) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDialect getDialect(MappedStatement ms) {
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        if (this.urlDialectMap.containsKey(url)) {
            return this.urlDialectMap.get(url);
        }
        try {
            this.lock.lock();
            if (this.urlDialectMap.containsKey(url)) {
                AbstractDialect abstractDialect = this.urlDialectMap.get(url);
                return abstractDialect;
            }
            if (StringUtils.isEmpty(url)) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialectStr = this.fromJdbcUrl(url);
            if (dialectStr == null) {
                throw new PageException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7 helperDialect \u53c2\u6570\u6307\u5b9a!");
            }
            AbstractDialect dialect = this.initDialect(dialectStr, this.properties);
            this.urlDialectMap.put(url, dialect);
            AbstractDialect abstractDialect = dialect;
            return abstractDialect;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setProperties(Properties properties) {
        String closeConn = properties.getProperty("closeConn");
        if (StringUtils.isNotEmpty(closeConn)) {
            this.closeConn = Boolean.parseBoolean(closeConn);
        }
        String dialect = properties.getProperty("helperDialect");
        String runtimeDialect = properties.getProperty("autoRuntimeDialect");
        if (StringUtils.isNotEmpty(runtimeDialect) && runtimeDialect.equalsIgnoreCase("TRUE")) {
            this.autoDialect = false;
            this.properties = properties;
        } else if (StringUtils.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = properties;
        } else {
            this.autoDialect = false;
            this.delegate = this.initDialect(dialect, properties);
        }
    }

    static {
        dialectAliasMap.put("mysql", MySqlDialect.class);
        dialectAliasMap.put("mariadb", MySqlDialect.class);
        dialectAliasMap.put("sqlite", MySqlDialect.class);
    }
}

