/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class ClassScanner {
    public static List<Class> scan(String scanPackage) {
        LinkedList<Class> clazzs = new LinkedList<Class>();
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)scanPackage) + "/**/*.class";
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (Resource resource : resources) {
                if (!resource.isReadable()) continue;
                MetadataReader reader = readerFactory.getMetadataReader(resource);
                String className = reader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(className);
                clazzs.add(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error scanning package: ".concat(scanPackage), e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error scanning package: ".concat(scanPackage), e);
        }
        return clazzs;
    }
}

