/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.util.Optional;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.webflux.ui.SwaggerIndexTransformer;
import org.springdoc.webflux.ui.SwaggerResourceResolver;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceTransformer;

public class SwaggerWebFluxConfigurer
implements WebFluxConfigurer {
    private final String swaggerPath;
    private final String webJarsPrefixUrl;
    private final SwaggerIndexTransformer swaggerIndexTransformer;
    private final Optional<ActuatorProvider> actuatorProvider;
    private final SwaggerResourceResolver swaggerResourceResolver;

    public SwaggerWebFluxConfigurer(SwaggerUiConfigParameters swaggerUiConfigParameters, SpringDocConfigProperties springDocConfigProperties, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider, SwaggerResourceResolver swaggerResourceResolver) {
        this.swaggerPath = swaggerUiConfigParameters.getPath();
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.actuatorProvider = actuatorProvider;
        this.swaggerResourceResolver = swaggerResourceResolver;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf("/"));
        }
        if (this.actuatorProvider.isPresent() && this.actuatorProvider.get().isUseManagementPort()) {
            uiRootPath.append(this.actuatorProvider.get().getBasePath());
        }
        registry.addResourceHandler(new String[]{uiRootPath + this.webJarsPrefixUrl + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addResolver((ResourceResolver)this.swaggerResourceResolver).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }
}

