/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.mariadb;

import io.micrometer.observation.ObservationRegistry;
import javax.sql.DataSource;
import org.springframework.ai.autoconfigure.vectorstore.mariadb.MariaDbStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.mariadb.MariaDBVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

@AutoConfiguration(after={JdbcTemplateAutoConfiguration.class})
@ConditionalOnClass(value={MariaDBVectorStore.class, DataSource.class, JdbcTemplate.class})
@EnableConfigurationProperties(value={MariaDbStoreProperties.class})
public class MariaDbStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy mariaDbStoreBatchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public MariaDBVectorStore vectorStore(JdbcTemplate jdbcTemplate, EmbeddingModel embeddingModel, MariaDbStoreProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        boolean initializeSchema = properties.isInitializeSchema();
        return ((MariaDBVectorStore.MariaDBBuilder)((MariaDBVectorStore.MariaDBBuilder)((MariaDBVectorStore.MariaDBBuilder)MariaDBVectorStore.builder((JdbcTemplate)jdbcTemplate, (EmbeddingModel)embeddingModel).schemaName(properties.getSchemaName()).vectorTableName(properties.getTableName()).schemaValidation(properties.isSchemaValidation()).dimensions(properties.getDimensions()).distanceType(properties.getDistanceType()).contentFieldName(properties.getContentFieldName()).embeddingFieldName(properties.getEmbeddingFieldName()).idFieldName(properties.getIdFieldName()).metadataFieldName(properties.getMetadataFieldName()).removeExistingVectorStoreTable(properties.isRemoveExistingVectorStoreTable()).initializeSchema(initializeSchema).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy)).maxDocumentBatchSize(properties.getMaxDocumentBatchSize()).build();
    }
}

