/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.couchbase;

import com.couchbase.client.java.Bucket;
import javax.validation.Validator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.couchbase.CouchbaseAutoConfiguration;
import org.springframework.boot.autoconfigure.data.couchbase.CouchbaseConfigurerAdapterConfiguration;
import org.springframework.boot.autoconfigure.data.couchbase.CouchbaseDataProperties;
import org.springframework.boot.autoconfigure.data.couchbase.SpringBootCouchbaseDataConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.couchbase.core.mapping.event.ValidatingCouchbaseEventListener;
import org.springframework.data.couchbase.repository.CouchbaseRepository;

@Configuration
@ConditionalOnClass(value={Bucket.class, CouchbaseRepository.class})
@AutoConfigureAfter(value={CouchbaseAutoConfiguration.class})
@EnableConfigurationProperties(value={CouchbaseDataProperties.class})
@Import(value={CouchbaseConfigurerAdapterConfiguration.class, SpringBootCouchbaseDataConfiguration.class})
public class CouchbaseDataAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={Validator.class})
    public static class ValidationConfiguration {
        @Bean
        @ConditionalOnBean(value={Validator.class})
        public ValidatingCouchbaseEventListener validationEventListener(Validator validator) {
            return new ValidatingCouchbaseEventListener(validator);
        }
    }
}

