/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.netty.handler.ssl.SslContextBuilder;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.config.HttpClientProperties;
import org.springframework.util.ResourceUtils;

public abstract class AbstractSslConfigurer<T, S> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final HttpClientProperties.Ssl ssl;

    protected AbstractSslConfigurer(HttpClientProperties.Ssl sslProperties) {
        this.ssl = sslProperties;
    }

    public abstract S configureSsl(T var1) throws SSLException;

    protected HttpClientProperties.Ssl getSslProperties() {
        return this.ssl;
    }

    protected X509Certificate[] getTrustedX509CertificatesForTrustManager() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
            for (String trustedCert : this.ssl.getTrustedX509Certificates()) {
                try {
                    URL url = ResourceUtils.getURL((String)trustedCert);
                    Collection<? extends Certificate> certs = certificateFactory.generateCertificates(url.openStream());
                    allCerts.addAll(certs);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not load certificate '" + trustedCert + "'", e);
                }
            }
            return allCerts.toArray(new X509Certificate[allCerts.size()]);
        }
        catch (CertificateException e1) {
            throw new RuntimeException("Could not load CertificateFactory X.509", e1);
        }
    }

    protected KeyManagerFactory getKeyManagerFactory() {
        try {
            if (this.ssl.getKeyStore() != null && this.ssl.getKeyStore().length() > 0) {
                char[] keyPassword;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                char[] cArray = keyPassword = this.ssl.getKeyPassword() != null ? this.ssl.getKeyPassword().toCharArray() : null;
                if (keyPassword == null && this.ssl.getKeyStorePassword() != null) {
                    keyPassword = this.ssl.getKeyStorePassword().toCharArray();
                }
                keyManagerFactory.init(this.createKeyStore(), keyPassword);
                return keyManagerFactory;
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected KeyStore createKeyStore() {
        try {
            KeyStore store = this.ssl.getKeyStoreProvider() != null ? KeyStore.getInstance(this.ssl.getKeyStoreType(), this.ssl.getKeyStoreProvider()) : KeyStore.getInstance(this.ssl.getKeyStoreType());
            try {
                URL url = ResourceUtils.getURL((String)this.ssl.getKeyStore());
                store.load(url.openStream(), this.ssl.getKeyStorePassword() != null ? this.ssl.getKeyStorePassword().toCharArray() : null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load key store ' " + this.ssl.getKeyStore() + "'", e);
            }
            return store;
        }
        catch (KeyStoreException | NoSuchProviderException e) {
            throw new RuntimeException("Could not load KeyStore for given type and provider", e);
        }
    }

    protected void setTrustManager(SslContextBuilder sslContextBuilder, X509Certificate ... trustedX509Certificates) {
        sslContextBuilder.trustManager(trustedX509Certificates);
    }

    protected void setTrustManager(SslContextBuilder sslContextBuilder, TrustManagerFactory factory) {
        sslContextBuilder.trustManager(factory);
    }
}

