/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.headers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;

@ConfigurationProperties(value="spring.cloud.gateway.filter.remove-hop-by-hop")
public class RemoveHopByHopHeadersFilter
implements HttpHeadersFilter,
Ordered {
    public static final Set<String> HEADERS_REMOVED_ON_REQUEST = new HashSet<String>(Arrays.asList("connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "x-application-context", "upgrade"));
    private int order = 0x7FFFFFFE;
    private Set<String> headers = HEADERS_REMOVED_ON_REQUEST;

    public Set<String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Set<String> headers) {
        Assert.notNull(headers, (String)"headers may not be null");
        this.headers = headers.stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public HttpHeaders filter(HttpHeaders originalHeaders, ServerWebExchange exchange) {
        HttpHeaders filtered = new HttpHeaders();
        List<String> connectionOptions = originalHeaders.getConnection().stream().map(String::toLowerCase).toList();
        HashSet<String> headersToRemove = new HashSet<String>(this.headers);
        headersToRemove.addAll(connectionOptions);
        for (Map.Entry entry : originalHeaders.entrySet()) {
            if (headersToRemove.contains(((String)entry.getKey()).toLowerCase())) continue;
            filtered.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        return filtered;
    }

    @Override
    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST) || type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

