/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.core;

import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.HintRequestContext;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.RequestDataContext;
import org.springframework.cloud.loadbalancer.core.DelegatingServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class HintBasedServiceInstanceListSupplier
extends DelegatingServiceInstanceListSupplier {
    private final LoadBalancerProperties properties;

    public HintBasedServiceInstanceListSupplier(ServiceInstanceListSupplier delegate, LoadBalancerProperties properties) {
        super(delegate);
        this.properties = properties;
    }

    @Override
    public Flux<List<ServiceInstance>> get() {
        return (Flux)this.delegate.get();
    }

    @Override
    public Flux<List<ServiceInstance>> get(Request request) {
        return this.delegate.get(request).map(instances -> this.filteredByHint((List<ServiceInstance>)instances, this.getHint(request.getContext())));
    }

    private String getHint(Object requestContext) {
        if (requestContext == null) {
            return null;
        }
        String hint = null;
        if (requestContext instanceof RequestDataContext) {
            hint = this.getHintFromHeader((RequestDataContext)requestContext);
        }
        if (!StringUtils.hasText(hint) && requestContext instanceof HintRequestContext) {
            hint = ((HintRequestContext)requestContext).getHint();
        }
        return hint;
    }

    private String getHintFromHeader(RequestDataContext context) {
        HttpHeaders headers;
        if (context.getClientRequest() != null && (headers = context.getClientRequest().getHeaders()) != null) {
            return headers.getFirst(this.properties.getHintHeaderName());
        }
        return null;
    }

    private List<ServiceInstance> filteredByHint(List<ServiceInstance> instances, String hint) {
        if (!StringUtils.hasText((String)hint)) {
            return instances;
        }
        ArrayList<ServiceInstance> filteredInstances = new ArrayList<ServiceInstance>();
        for (ServiceInstance serviceInstance : instances) {
            if (!serviceInstance.getMetadata().getOrDefault("hint", "").equals(hint)) continue;
            filteredInstances.add(serviceInstance);
        }
        if (filteredInstances.size() > 0) {
            return filteredInstances;
        }
        return instances;
    }
}

