/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import com.google.common.reflect.TypeToken;
import com.netflix.client.ClientException;
import com.netflix.client.http.CaseInsensitiveMultiMap;
import com.netflix.client.http.HttpHeaders;
import com.netflix.client.http.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class RibbonApacheHttpResponse
implements HttpResponse {
    private org.apache.http.HttpResponse httpResponse;
    private URI uri;

    public RibbonApacheHttpResponse(org.apache.http.HttpResponse httpResponse, URI uri) {
        Assert.notNull((Object)httpResponse, (String)"httpResponse can not be null");
        this.httpResponse = httpResponse;
        this.uri = uri;
    }

    public Object getPayload() throws ClientException {
        try {
            if (!this.hasPayload()) {
                return null;
            }
            return this.httpResponse.getEntity().getContent();
        }
        catch (IOException e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasPayload() {
        return this.httpResponse.getEntity() != null;
    }

    public boolean isSuccess() {
        return HttpStatus.valueOf((int)this.httpResponse.getStatusLine().getStatusCode()).is2xxSuccessful();
    }

    public URI getRequestedURI() {
        return this.uri;
    }

    public int getStatus() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getStatusLine() {
        return this.httpResponse.getStatusLine().toString();
    }

    public Map<String, Collection<String>> getHeaders() {
        HashMap<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        for (Header header : this.httpResponse.getAllHeaders()) {
            if (headers.containsKey(header.getName())) {
                ((Collection)headers.get(header.getName())).add(header.getValue());
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(header.getValue());
            headers.put(header.getName(), values);
        }
        return headers;
    }

    public HttpHeaders getHttpHeaders() {
        CaseInsensitiveMultiMap headers = new CaseInsensitiveMultiMap();
        for (Header header : this.httpResponse.getAllHeaders()) {
            headers.addHeader(header.getName(), header.getValue());
        }
        return headers;
    }

    public void close() {
        if (this.httpResponse != null && this.httpResponse.getEntity() != null) {
            try {
                this.httpResponse.getEntity().getContent().close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public InputStream getInputStream() {
        try {
            if (!this.hasPayload()) {
                return null;
            }
            return this.httpResponse.getEntity().getContent();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean hasEntity() {
        return this.hasPayload();
    }

    public <T> T getEntity(Class<T> type) throws Exception {
        return null;
    }

    public <T> T getEntity(Type type) throws Exception {
        return null;
    }

    public <T> T getEntity(TypeToken<T> type) throws Exception {
        return null;
    }
}

