/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping;

import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface PersistentPropertyAccessor<T> {
    public void setProperty(PersistentProperty<?> var1, @Nullable Object var2);

    default public void setProperty(PersistentPropertyPath<? extends PersistentProperty<?>> path, @Nullable Object value) {
        Object parent;
        Assert.notNull(path, (String)"PersistentPropertyPath must not be null!");
        Assert.isTrue((!path.isEmpty() ? 1 : 0) != 0, (String)"PersistentPropertyPath must not be empty!");
        PersistentPropertyPath<PersistentProperty<?>> parentPath = path.getParentPath();
        PersistentProperty<?> leafProperty = path.getRequiredLeafProperty();
        Object object = parent = parentPath.isEmpty() ? this.getBean() : this.getProperty(parentPath);
        if (parent == null) {
            String nullIntermediateMessage = "Cannot lookup property %s on null intermediate! Original path was: %s on %s.";
            throw new MappingException(String.format(nullIntermediateMessage, parentPath.getLeafProperty(), path.toDotPath(), this.getBean().getClass().getName()));
        }
        PersistentPropertyAccessor<T> accessor = parent == this.getBean() ? this : leafProperty.getOwner().getPropertyAccessor(parent);
        accessor.setProperty(leafProperty, value);
        if (parentPath.isEmpty()) {
            return;
        }
        T bean = accessor.getBean();
        if (bean != parent) {
            this.setProperty(parentPath, bean);
        }
    }

    @Nullable
    public Object getProperty(PersistentProperty<?> var1);

    @Nullable
    default public Object getProperty(PersistentPropertyPath<? extends PersistentProperty<?>> path) {
        T bean;
        Object current = bean = this.getBean();
        if (path.isEmpty()) {
            return bean;
        }
        for (PersistentProperty persistentProperty : path) {
            if (current == null) {
                String nullIntermediateMessage = "Cannot lookup property %s on null intermediate! Original path was: %s on %s.";
                throw new MappingException(String.format(nullIntermediateMessage, persistentProperty, path.toDotPath(), bean.getClass().getName()));
            }
            PersistentEntity entity = persistentProperty.getOwner();
            PersistentPropertyAccessor<T> accessor = entity.getPropertyAccessor(current);
            current = accessor.getProperty(persistentProperty);
        }
        return current;
    }

    public T getBean();
}

