/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map.repository.config;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.QueryEngineFactory;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.map.MapKeyValueAdapter;
import org.springframework.data.map.repository.config.EnableMapRepositories;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class MapRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    @Override
    public String getModuleName() {
        return "Map";
    }

    @Override
    protected String getModulePrefix() {
        return "map";
    }

    @Override
    protected String getDefaultKeyValueTemplateRef() {
        return "mapKeyValueTemplate";
    }

    @Override
    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.rootBeanDefinition(MapKeyValueAdapter.class);
        adapterBuilder.addConstructorArgValue(MapRepositoryConfigurationExtension.getMapTypeToUse(configurationSource));
        SortAccessor<?> sortAccessor = MapRepositoryConfigurationExtension.getSortAccessor(configurationSource);
        QueryEngine<?, ?, ?> queryEngine = MapRepositoryConfigurationExtension.getQueryEngine(sortAccessor, configurationSource);
        if (queryEngine != null) {
            adapterBuilder.addConstructorArgValue(queryEngine);
        } else if (sortAccessor != null) {
            adapterBuilder.addConstructorArgValue(sortAccessor);
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(KeyValueTemplate.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)adapterBuilder, (Object)configurationSource.getSource()));
        builder.setRole(1);
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)builder, (Object)configurationSource.getSource());
    }

    private static Class<? extends Map> getMapTypeToUse(RepositoryConfigurationSource source) {
        return (Class)MapRepositoryConfigurationExtension.getAnnotationAttributes(source).get("mapType");
    }

    @Nullable
    private static SortAccessor<?> getSortAccessor(RepositoryConfigurationSource source) {
        Class sortAccessorType = (Class)MapRepositoryConfigurationExtension.getAnnotationAttributes(source).get("sortAccessor");
        if (sortAccessorType != null && !sortAccessorType.isInterface()) {
            return (SortAccessor)BeanUtils.instantiateClass((Class)sortAccessorType);
        }
        return null;
    }

    @Nullable
    private static QueryEngine<?, ?, ?> getQueryEngine(@Nullable SortAccessor<?> sortAccessor, RepositoryConfigurationSource source) {
        Constructor constructor;
        Class queryEngineFactoryType = (Class)MapRepositoryConfigurationExtension.getAnnotationAttributes(source).get("queryEngineFactory");
        if (queryEngineFactoryType == null || queryEngineFactoryType.isInterface()) {
            return null;
        }
        if (sortAccessor != null && (constructor = ClassUtils.getConstructorIfAvailable((Class)queryEngineFactoryType, (Class[])new Class[]{SortAccessor.class})) != null) {
            return ((QueryEngineFactory)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{sortAccessor})).create();
        }
        return ((QueryEngineFactory)BeanUtils.instantiateClass((Class)queryEngineFactoryType)).create();
    }

    private static Map<String, Object> getAnnotationAttributes(RepositoryConfigurationSource source) {
        AnnotationMetadata annotationSource = (AnnotationMetadata)source.getSource();
        if (annotationSource == null) {
            throw new IllegalArgumentException("AnnotationSource not available");
        }
        Map annotationAttributes = annotationSource.getAnnotationAttributes(EnableMapRepositories.class.getName());
        if (annotationAttributes == null) {
            throw new IllegalStateException("No annotation attributes for @EnableMapRepositories");
        }
        return annotationAttributes;
    }
}

