/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.DefaultBoundKeyOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;

class DefaultBoundGeoOperations<K, M>
extends DefaultBoundKeyOperations<K>
implements BoundGeoOperations<K, M> {
    private final GeoOperations<K, M> ops;

    DefaultBoundGeoOperations(K key, RedisOperations<K, M> operations) {
        super(key, operations);
        this.ops = operations.opsForGeo();
    }

    @Override
    public Long add(Point point, M member) {
        return this.ops.add(this.getKey(), point, member);
    }

    @Override
    public Long add(RedisGeoCommands.GeoLocation<M> location) {
        return this.ops.add(this.getKey(), location);
    }

    @Override
    public Long add(Map<M, Point> memberCoordinateMap) {
        return this.ops.add(this.getKey(), memberCoordinateMap);
    }

    @Override
    public Long add(Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        return this.ops.add(this.getKey(), locations);
    }

    @Override
    public Distance distance(M member1, M member2) {
        return this.ops.distance(this.getKey(), member1, member2);
    }

    @Override
    public Distance distance(M member1, M member2, Metric unit) {
        return this.ops.distance(this.getKey(), member1, member2, unit);
    }

    @Override
    public List<String> hash(M ... members) {
        return this.ops.hash(this.getKey(), members);
    }

    @Override
    public List<Point> position(M ... members) {
        return this.ops.position(this.getKey(), members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle within) {
        return this.ops.radius(this.getKey(), within);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(Circle within, RedisGeoCommands.GeoRadiusCommandArgs param) {
        return this.ops.radius(this.getKey(), within, param);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, double radius) {
        return this.ops.radius(this.getKey(), member, radius);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M member, Distance distance) {
        return this.ops.radius(this.getKey(), member, distance);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs param) {
        return this.ops.radius(this.getKey(), member, distance, param);
    }

    @Override
    public Long remove(M ... members) {
        return this.ops.remove(this.getKey(), members);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(GeoReference<M> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.ops.search(this.getKey(), reference, geoPredicate, args);
    }

    @Override
    public Long searchAndStore(K destKey, GeoReference<M> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.ops.searchAndStore(this.getKey(), destKey, reference, geoPredicate, args);
    }

    @Override
    public DataType getType() {
        return DataType.ZSET;
    }
}

