/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

class ControllerMappingReflectiveProcessor
implements ReflectiveProcessor {
    private final BindingReflectionHintsRegistrar bindingRegistrar = new BindingReflectionHintsRegistrar();

    ControllerMappingReflectiveProcessor() {
    }

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        if (element instanceof Class) {
            Class type = (Class)element;
            this.registerTypeHints(hints, type);
        } else if (element instanceof Method) {
            Method method = (Method)element;
            this.registerMethodHints(hints, method);
        }
    }

    protected final BindingReflectionHintsRegistrar getBindingRegistrar() {
        return this.bindingRegistrar;
    }

    protected void registerTypeHints(ReflectionHints hints, Class<?> type) {
        hints.registerType(type, new MemberCategory[0]);
    }

    protected void registerMethodHints(ReflectionHints hints, Method method) {
        hints.registerMethod(method, ExecutableMode.INVOKE);
        for (Parameter parameter : method.getParameters()) {
            this.registerParameterTypeHints(hints, MethodParameter.forParameter((Parameter)parameter));
        }
        this.registerReturnTypeHints(hints, MethodParameter.forExecutable((Executable)method, (int)-1));
    }

    protected void registerParameterTypeHints(ReflectionHints hints, MethodParameter methodParameter) {
        if (methodParameter.hasParameterAnnotation(RequestBody.class) || methodParameter.hasParameterAnnotation(ModelAttribute.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{methodParameter.getGenericParameterType()});
        } else if (HttpEntity.class.isAssignableFrom(methodParameter.getParameterType())) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{this.getHttpEntityType(methodParameter)});
        }
    }

    protected void registerReturnTypeHints(ReflectionHints hints, MethodParameter returnTypeParameter) {
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)returnTypeParameter.getContainingClass(), ResponseBody.class) || returnTypeParameter.hasMethodAnnotation(ResponseBody.class)) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{returnTypeParameter.getGenericParameterType()});
        } else if (HttpEntity.class.isAssignableFrom(returnTypeParameter.getParameterType())) {
            this.bindingRegistrar.registerReflectionHints(hints, new Type[]{this.getHttpEntityType(returnTypeParameter)});
        }
    }

    @Nullable
    private Type getHttpEntityType(MethodParameter parameter) {
        MethodParameter nestedParameter = parameter.nested();
        return nestedParameter.getNestedParameterType() == nestedParameter.getParameterType() ? null : nestedParameter.getNestedParameterType();
    }
}

