/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.slf4jtest;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import uk.org.lidalia.lang.Exceptions;

class OverridableProperties {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private final String propertySourceName;
    private final Properties properties;
    private static final Function<InputStream, Properties> loadProperties = new Function<InputStream, Properties>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Properties apply(InputStream propertyResource) {
            try (InputStream closablePropertyResource = propertyResource;){
                Properties loadedProperties = new Properties();
                loadedProperties.load(closablePropertyResource);
                Properties properties = loadedProperties;
                return properties;
            }
            catch (IOException ioException) {
                return (Properties)Exceptions.throwUnchecked((Throwable)ioException, null);
            }
        }
    };

    OverridableProperties(String propertySourceName) throws IOException {
        this.propertySourceName = propertySourceName;
        this.properties = this.getProperties();
    }

    private Properties getProperties() throws IOException {
        Optional resourceAsStream = Optional.fromNullable((Object)Thread.currentThread().getContextClassLoader().getResourceAsStream(this.propertySourceName + ".properties"));
        return (Properties)resourceAsStream.transform(loadProperties).or((Object)EMPTY_PROPERTIES);
    }

    String getProperty(String propertyKey, String defaultValue) {
        String propertyFileProperty = this.properties.getProperty(propertyKey, defaultValue);
        return System.getProperty(this.propertySourceName + "." + propertyKey, propertyFileProperty);
    }
}

