/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq;

import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.MessageProperties;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqServiceImpl;
import com.dtyunxi.cube.plugin.mq.runner.MQRegisterRunner;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMQService;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.api.MQFactory;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MessageProperties.class, TopicRegistryVo.class})
public class CubeMQAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CubeMQAutoConfiguration.class);
    @Autowired
    private MessageRegistryVo messageRegistryVo;
    @Autowired
    private IProducer commonsProducer;
    @Autowired
    private IConsumer commonsConsumer;
    @Value(value="${cube.starter.mq.default.consumer:}")
    private String defaultConsumer;
    @Value(value="${spring.application.name:}")
    private String envModule;
    @Autowired
    private TopicRegistryVo topicRegistryVo;
    @Value(value="${cube.global.profile:dev}")
    private String globalProfile;

    @Bean
    public MQRegisterRunner mqRegisteRunner() {
        return new MQRegisterRunner(this.commonsMqService(), this.messageRegistryVo, this.topicRegistryVo, this.getConsumer());
    }

    @Bean
    public ICommonsMqService commonsMqService() {
        return new CommonsMqServiceImpl(this.commonsProducer, this.commonsConsumer, this.messageRegistryVo, this.globalProfile, this.topicRegistryVo);
    }

    @Bean
    @ConditionalOnMissingBean
    public IProducer producerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createProducer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IConsumer consumerBean(@Qualifier(value="createIMQService") IMQService createIMQService) {
        return createIMQService.createConsumer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IMQService createIMQService() {
        logger.info("messageRegistryVo \uff1a {}", (Object)this.messageRegistryVo);
        return MQFactory.createMQ((MessageRegistryVo)this.messageRegistryVo);
    }

    private String getConsumer() {
        return CommonsMqHelper.parseConsumer(this.messageRegistryVo, this.defaultConsumer, this.envModule);
    }
}

