/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq.runner;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;

@Order(value=0x7FFFFFFF)
public class MQRegisterRunner
implements BeanPostProcessor,
CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(MQRegisterRunner.class);
    private TopicRegistryVo topicRegistryVo;
    private MessageRegistryVo registryVo;
    private ICommonsMqService commonsMqService;
    private String consumer;

    public MQRegisterRunner(ICommonsMqService commonsMqService, MessageRegistryVo registryVo, TopicRegistryVo topicRegistryVo, String consumer) {
        this.commonsMqService = commonsMqService;
        this.registryVo = registryVo;
        this.topicRegistryVo = topicRegistryVo;
        this.consumer = consumer;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof IMessageProcessor) {
            MQDesc mqDesc = bean.getClass().getAnnotation(MQDesc.class);
            if (null == mqDesc) {
                return bean;
            }
            String topic = mqDesc.topic();
            String consumer = CommonsMqHelper.parseConsumer(this.registryVo, mqDesc.consumer(), this.consumer);
            String tag = mqDesc.tag();
            String msgType = mqDesc.msgType();
            if (StringUtils.isBlank((CharSequence)topic)) {
                topic = "single".equals(mqDesc.msgType()) ? this.topicRegistryVo.getSingleTopic() : this.topicRegistryVo.getPublishTopic();
            }
            CommonsMqHelper.addProcessor(topic, consumer, tag, msgType, (IMessageProcessor)bean);
        }
        return bean;
    }

    public void run(String ... args) throws Exception {
        this.start();
    }

    private void start() {
        if (!CommonsMqHelper.processMap.keySet().isEmpty()) {
            for (String consumer : CommonsMqHelper.processMap.keySet()) {
                logger.info("\u5f00\u59cb\u76d1\u542c\uff1aconsumer: {}, processors:{}", (Object)consumer, (Object)JSON.toJSONString(CommonsMqHelper.processMap.get(consumer)));
                this.commonsMqService.start(consumer);
            }
        }
    }
}

