/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Example;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.ExampleBuilder;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.parameter.Examples;
import springfox.documentation.swagger.schema.ApiModelProperties;

@Component
@Order(value=-2147482648)
public class SwaggerExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private final DescriptionResolver descriptions;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public SwaggerExpandedParameterBuilder(DescriptionResolver descriptions, EnumTypeDeterminer enumTypeDeterminer) {
        this.descriptions = descriptions;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public void apply(ParameterExpansionContext context) {
        Optional apiModelPropertyOptional = context.findAnnotation(ApiModelProperty.class);
        apiModelPropertyOptional.ifPresent(apiModelProperty -> this.fromApiModelProperty(context, (ApiModelProperty)apiModelProperty));
        Optional apiParamOptional = context.findAnnotation(ApiParam.class);
        apiParamOptional.ifPresent(apiParam -> this.fromApiParam(context, (ApiParam)apiParam));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply((DocumentationType)delimiter);
    }

    private void fromApiParam(ParameterExpansionContext context, ApiParam apiParam) {
        String allowableProperty = Optional.ofNullable(apiParam.allowableValues()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
        AllowableValues allowable = this.allowableValues(Optional.ofNullable(allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiParam.name());
        context.getParameterBuilder().description(this.descriptions.resolve(apiParam.value())).defaultValue(apiParam.defaultValue()).required(apiParam.required()).allowMultiple(apiParam.allowMultiple()).allowableValues(allowable).parameterAccess(apiParam.access()).hidden(apiParam.hidden()).scalarExample((Object)apiParam.example()).complexExamples(Examples.examples((Example)apiParam.examples())).order(-2147482648).build();
        context.getRequestParameterBuilder().description(this.descriptions.resolve(apiParam.value())).required(Boolean.valueOf(apiParam.required())).hidden(Boolean.valueOf(apiParam.hidden())).example(new ExampleBuilder().value((Object)apiParam.example()).build()).precedence(-2147482648).query(q -> q.enumerationFacet(e -> e.allowedValues(allowable)));
    }

    private void fromApiModelProperty(ParameterExpansionContext context, ApiModelProperty apiModelProperty) {
        String allowableProperty = Optional.ofNullable(apiModelProperty.allowableValues()).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
        AllowableValues allowable = this.allowableValues(Optional.ofNullable(allowableProperty), context.getFieldType().getErasedType());
        this.maybeSetParameterName(context, apiModelProperty.name());
        context.getParameterBuilder().description(this.descriptions.resolve(apiModelProperty.value())).required(apiModelProperty.required()).allowableValues(allowable).parameterAccess(apiModelProperty.access()).hidden(apiModelProperty.hidden()).scalarExample((Object)apiModelProperty.example()).order(-2147482648).build();
        context.getRequestParameterBuilder().description(this.descriptions.resolve(apiModelProperty.value())).required(Boolean.valueOf(apiModelProperty.required())).hidden(Boolean.valueOf(apiModelProperty.hidden())).example(new ExampleBuilder().value((Object)apiModelProperty.example()).build()).precedence(-2147482648).query(q -> q.enumerationFacet(e -> e.allowedValues(allowable)));
    }

    private void maybeSetParameterName(ParameterExpansionContext context, String parameterName) {
        if (!StringUtils.isEmpty((Object)parameterName)) {
            if ("query".equals(context.getParameterType()) && !StringUtils.isEmpty((Object)context.getParentName())) {
                parameterName = String.format("%s.%s", context.getParentName(), parameterName);
            }
            context.getParameterBuilder().name(parameterName);
            context.getRequestParameterBuilder().name(parameterName);
        }
    }

    private AllowableValues allowableValues(Optional<String> optionalAllowable, Class<?> fieldType) {
        AllowableListValues allowable = null;
        if (this.enumTypeDeterminer.isEnum(fieldType)) {
            allowable = new AllowableListValues(this.getEnumValues(fieldType), "LIST");
        } else if (optionalAllowable.isPresent()) {
            allowable = ApiModelProperties.allowableValueFromString((String)optionalAllowable.get());
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Stream.of(subject.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }
}

