/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.domain.event.config;

import com.dtyunxi.cube.domain.event.runner.MQRegisterExtRunner;
import com.dtyunxi.cube.plugin.mq.IMQConsumerRegister;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@ConditionalOnProperty(name={"dtyunxi.yundt.cube.conf.domain-event"}, havingValue="true", matchIfMissing=true)
@Configuration
public class CubeMQExtAutoConfiguration {
    private final MessageRegistryVo messageRegistryVo;
    private final TopicRegistryVo topicRegistryVo;
    @Value(value="${cube.starter.mq.default.consumer:}")
    private String defaultConsumer;
    @Value(value="${spring.application.name:}")
    private String envModule;

    public CubeMQExtAutoConfiguration(MessageRegistryVo messageRegistryVo, TopicRegistryVo topicRegistryVo) {
        this.messageRegistryVo = messageRegistryVo;
        this.topicRegistryVo = topicRegistryVo;
    }

    @Bean(value={"mqRegisterRunnerExt"})
    @DependsOn(value={"springBeanUtil"})
    @ConditionalOnProperty(prefix="cube.starter.mq", value={"enabled"}, havingValue="true", matchIfMissing=true)
    public IMQConsumerRegister mqRegisterRunnerExt() {
        return new MQRegisterExtRunner(this.messageRegistryVo, this.topicRegistryVo, this.getConsumer());
    }

    private String getConsumer() {
        return CommonsMqHelper.parseConsumer((MessageRegistryVo)this.messageRegistryVo, (String)this.defaultConsumer, (String)this.envModule);
    }
}

