/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.domain.event.runner;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.domain.event.cache.LocalCache;
import com.dtyunxi.cube.domain.event.constant.Constant;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleBaseSettingRespDto;
import com.dtyunxi.cube.starter.bundle.dto.response.BundleSettingRespDto;
import com.dtyunxi.cube.starter.bundle.service.BundleDescService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DEParameterChangedDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.DomainEventQueryReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.DomainEventRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDomainEventQueryApi;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PullDomainEventParameterRunner
implements EnvironmentAware,
CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(PullDomainEventParameterRunner.class);
    @Resource
    private IDomainEventQueryApi domainEventQueryApi;
    private Environment environment;

    public void run(String ... args) throws Exception {
        HashMap artifactMap = Maps.newHashMap();
        try {
            BundleDescService.convertSettings((Map)artifactMap, (Boolean)true);
        }
        catch (Exception e) {
            logger.warn("\u8bfb\u53d6\u9886\u57df\u4e8b\u4ef6\u63cf\u8ff0\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        if (artifactMap.size() > 0) {
            Collection bundleBaseSettingRespDtoList = artifactMap.values();
            List collect = bundleBaseSettingRespDtoList.stream().map(BundleBaseSettingRespDto::getSettings).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                return;
            }
            ArrayList settings = new ArrayList();
            for (List settingList : collect) {
                settings.addAll(settingList);
            }
            for (BundleSettingRespDto.Setting setting2 : settings) {
                if (!setting2.getValueType().equals(Constant.DOMAINEVENT_EXTPT)) continue;
                DEParameterChangedDto.DomainEventParameter parameter = (DEParameterChangedDto.DomainEventParameter)JSON.parseObject((String)setting2.getParameter(), DEParameterChangedDto.DomainEventParameter.class);
                LocalCache.getDomainEventParameterMap().put(setting2.getCode(), parameter);
                LocalCache.getTopic2DomainEvent().put(parameter.getParameterKey(), setting2.getCode());
                LocalCache.getDtoCode2DomainEvent().put(parameter.getDtoCode(), setting2.getCode());
            }
            List<String> domainCodes = settings.stream().filter(setting -> setting.getValueType().equals(Constant.DOMAINEVENT_EXTPT)).map(BundleSettingRespDto.Setting::getCode).collect(Collectors.toList());
            List<DomainEventRespDto.Setting> settingRespDtoList = this.queryDomainEvent(domainCodes);
            if (!CollectionUtils.isEmpty(settingRespDtoList)) {
                for (DomainEventRespDto.Setting settingRespDto : settingRespDtoList) {
                    if (!LocalCache.getDomainEventParameterMap().containsKey(settingRespDto.getCode())) continue;
                    DEParameterChangedDto.DomainEventParameter domainEventParameter = (DEParameterChangedDto.DomainEventParameter)JSON.parseObject((String)settingRespDto.getParameter(), DEParameterChangedDto.DomainEventParameter.class);
                    String topic = this.resolvePlaceholders(domainEventParameter.getTopic());
                    String tag = this.resolvePlaceholders(domainEventParameter.getTag());
                    domainEventParameter.setTopic(topic);
                    domainEventParameter.setTag(tag);
                    LocalCache.getDomainEventParameterMap().put(settingRespDto.getCode(), domainEventParameter);
                    logger.info("\u9886\u57df\u4e8b\u4ef6\u7684MQ\u63a8\u9001\u8bbe\u5b9a,domainEventCode:{} --> topic:{}, tag:{}", new Object[]{settingRespDto.getCode(), topic, tag});
                }
            }
        }
        LocalCache.DOMAIN_EVENT_INIT_FLAG = 1;
    }

    private String resolvePlaceholders(String placeHolder) {
        if (!StringUtils.isEmpty((Object)placeHolder)) {
            return this.environment.resolvePlaceholders(placeHolder);
        }
        return placeHolder;
    }

    private List<DomainEventRespDto.Setting> queryDomainEvent(List<String> domainCodes) {
        List<Object> settings = new ArrayList<DomainEventRespDto.Setting>();
        if (CollectionUtils.isEmpty(domainCodes)) {
            return settings;
        }
        DomainEventQueryReqDto settingQueryDto = new DomainEventQueryReqDto();
        settingQueryDto.setDomainCodeList(domainCodes);
        try {
            RestResponse restResponse = this.domainEventQueryApi.queryDomainEvent(settingQueryDto);
            if (null != restResponse && "0".equals(restResponse.getResultCode())) {
                settings = ((DomainEventRespDto)restResponse.getData()).getSettings();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9886\u57df\u4e8b\u4ef6\u53c2\u6570\u5931\u8d25\uff1a", (Throwable)e);
        }
        return settings;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

