/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension;

import com.dtyunxi.cube.starter.extension.config.ConfBeanPostProcessor;
import com.dtyunxi.cube.starter.extension.config.LocalConfValueProperties;
import com.dtyunxi.cube.starter.extension.reader.BizConfQueryApiProxy;
import com.dtyunxi.cube.starter.extension.reader.BizConfQueryCacheProxy;
import com.dtyunxi.cube.starter.extension.reader.ConfReader;
import com.dtyunxi.cube.starter.extension.reader.ThreadCacheCleanInterceptor;
import com.dtyunxi.yundt.cube.center.data.api.query.IBizConfQueryApi;
import feign.QueryMapEncoder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@EnableConfigurationProperties
public class CubeExtensionPointAutoConfiguration {
    private static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || Temporal.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || URI.class == clazz || URL.class == clazz || Locale.class == clazz || Class.class == clazz;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    private static Map<String, Object> handle(String parentName, Object obj) throws IllegalAccessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Field> declaredFields = CubeExtensionPointAutoConfiguration.getDeclaredFields(obj.getClass());
        for (Field field : declaredFields) {
            String fieldName;
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            Object fieldVal = field.get(obj);
            if (fieldVal == null) continue;
            Class<?> fieldClazz = field.getType();
            String string = fieldName = parentName == null || parentName.isEmpty() ? field.getName() : parentName + "." + field.getName();
            if (CubeExtensionPointAutoConfiguration.isSimpleValueType(fieldClazz)) {
                params.put(fieldName, fieldVal);
                continue;
            }
            if (fieldClazz.isArray() && CubeExtensionPointAutoConfiguration.isSimpleValueType(fieldClazz.getComponentType())) {
                if (Array.getLength(fieldVal) <= 0) continue;
                params.put(fieldName, fieldVal);
                continue;
            }
            if (Collection.class.isAssignableFrom(fieldClazz)) {
                Collection collection = (Collection)fieldVal;
                Class elementType = CollectionUtils.findCommonElementType((Collection)collection);
                if (collection.size() <= 0 || elementType == null || !CubeExtensionPointAutoConfiguration.isSimpleValueType(elementType)) continue;
                params.put(fieldName, fieldVal);
                continue;
            }
            if (Map.class.isAssignableFrom(fieldClazz)) continue;
            params.putAll(CubeExtensionPointAutoConfiguration.handle(fieldName, fieldVal));
        }
        return params;
    }

    @Deprecated
    @Bean
    @ConditionalOnMissingBean(name={"queryMapEncoder"})
    @ConditionalOnProperty(prefix="cube.enhance.query-map-encoder", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QueryMapEncoder queryMapEncoder() {
        return object -> {
            if (object == null) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u5904\u7406\u4e0d\u652f\u6301\u6570\u7ec4\u6216\u8005\u96c6\u5408\u53c2\u6570");
            }
            try {
                return CubeExtensionPointAutoConfiguration.handle(null, object);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u5904\u7406\u51fa\u9519", e);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"bizConfQueryApiProxy"})
    public BizConfQueryApiProxy bizConfQueryApiProxy(IBizConfQueryApi bizConfQueryApi, BizConfQueryCacheProxy bizConfQueryCacheProxy) {
        return new BizConfQueryApiProxy(bizConfQueryApi, bizConfQueryCacheProxy);
    }

    @Bean
    @ConditionalOnMissingBean(name={"bizConfQueryCacheProxy"})
    public BizConfQueryCacheProxy bizConfQueryCacheProxy(IBizConfQueryApi bizConfQueryApi) {
        return new BizConfQueryCacheProxy(bizConfQueryApi);
    }

    @Bean
    @ConditionalOnMissingBean(name={"localConfValueProperties"})
    @ConfigurationProperties(prefix="dtyunxi.local.conf")
    public LocalConfValueProperties localConfValueProperties() {
        return new LocalConfValueProperties();
    }

    @Bean
    @ConditionalOnMissingBean(name={"confReader"})
    @ConditionalOnProperty(prefix="cube.enhance.conf-reader", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public ConfReader confReader(BizConfQueryApiProxy bizConfQueryApiProxy, LocalConfValueProperties localConfValueProperties, @Value(value="${cube.conf.reader.throw.error:false}") boolean confReaderThrowError) {
        return new ConfReader(bizConfQueryApiProxy, localConfValueProperties, confReaderThrowError);
    }

    @Bean
    @ConditionalOnMissingBean(name={"threadPoolExecutor"})
    public ThreadPoolExecutor threadPoolExecutor() {
        int availProcessors = Runtime.getRuntime().availableProcessors();
        return new ThreadPoolExecutor(availProcessors / 2, availProcessors * 2, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(5000), r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
    }

    @Bean
    @ConditionalOnMissingBean(name={"confBeanPostProcessor"})
    public ConfBeanPostProcessor confBeanPostProcessor() {
        return new ConfBeanPostProcessor();
    }

    @Bean
    @ConditionalOnMissingBean(name={"threadCacheCleanInterceptor"})
    public FilterRegistrationBean<ThreadCacheCleanInterceptor> threadCacheCleanInterceptor() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new ThreadCacheCleanInterceptor());
        registrationBean.setName("threadCacheCleanInterceptor");
        registrationBean.addUrlPatterns(new String[]{"/*"});
        return registrationBean;
    }
}

