/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.config;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.extension.constants.EnhanceConstants;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.starter.localcache.LocalCache;
import com.dtyunxi.huieryun.starter.localcache.LocalCacheRegistryProperties;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SettingLocalCache
extends LocalCache {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LocalCache.class);

    public SettingLocalCache(String name, LocalCacheRegistryProperties properties, ICacheService cacheService) {
        super(name, properties, cacheService);
        this.group = "REDIS_KEY_GROUP_PROFILE";
    }

    private boolean firstSearch() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return ServiceContext.getContext().getAttachment("FIRST_REQUEST_RANDOM_VALUE") == null && ServiceContext.getContext().getAttachment("ACTUAL_BID_ID_CODE") == null;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        return request.getHeader("FIRST_REQUEST_RANDOM_VALUE") == null && ServiceContext.getContext().getAttachment("FIRST_REQUEST_RANDOM_VALUE") == null && ServiceContext.getContext().getAttachment("ACTUAL_BID_ID_CODE") == null;
    }

    public Cache.ValueWrapper get(Object key) {
        Object value;
        Cache.ValueWrapper valueWrapper = super.get(key = this.getFinalKey(key));
        if (valueWrapper != null && (value = valueWrapper.get()) instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)value;
            if (linkedHashMap.containsKey("className")) {
                try {
                    value = JSONObject.parseObject((String)JSONObject.toJSONString((Object)value), Class.forName(linkedHashMap.get("className").toString()));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn("\u83b7\u53d6\u7f13\u5b58\u4fe1\u606f\u7684\u7c7b\u65b0\u578b\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                }
            } else {
                value = null;
                LOGGER.warn("\u7f13\u5b58\u65e0\u7c7b\u578b\u4fe1\u606f\uff0c\u4e22\u5f03\uff1a{}", key);
            }
            return new SimpleValueWrapper(value);
        }
        return valueWrapper;
    }

    public <T> T get(Object key, Class<T> type) {
        key = this.getFinalKey(key);
        return (T)super.get(key, type);
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        key = this.getFinalKey(key);
        return (T)super.get(key, valueLoader);
    }

    public void put(Object key, Object value) {
        if ((key = this.getFinalKey(key)) != null) {
            super.put(key, value);
        }
    }

    private Object getFinalKey(Object key) {
        String key2;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        String actualBizIdCode = null;
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            actualBizIdCode = request.getHeader("ACTUAL_BID_ID_CODE");
            ServiceContext.getContext().setAttachment("ACTUAL_BID_ID_CODE", actualBizIdCode);
        }
        if (key instanceof String && (key2 = (String)key).endsWith("DEFAULT_BID_ID_CODE")) {
            if (actualBizIdCode == null) {
                return null;
            }
            key2 = key2.replace("DEFAULT_BID_ID_CODE", actualBizIdCode);
            key = key2;
        }
        return key;
    }

    public static void putIntoServiceContext(String bizIdCode) {
        ServiceContext.getContext().setAttachment("ACTUAL_BID_ID_CODE", bizIdCode);
        ServiceContext.getContext().setAttachment("FIRST_REQUEST_RANDOM_VALUE", String.valueOf(EnhanceConstants.getId()));
    }
}

