/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.reader;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.extension.constants.EnhanceConstants;
import com.dtyunxi.cube.starter.extension.reader.BizConfQueryCacheProxy;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizExtImplQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizParamQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.enums.SettingLevelEnum;
import com.dtyunxi.yundt.cube.center.data.api.query.IBizConfQueryApi;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class BizConfQueryApiProxy {
    private static final Logger logger = LoggerFactory.getLogger(BizConfQueryApiProxy.class);
    private final IBizConfQueryApi bizConfQueryApi;
    private final BizConfQueryCacheProxy bizConfQueryCacheProxy;
    @Value(value="${dtyunxi.yundt.cube.conf.skip-biz-id:false}")
    private boolean noBizIdModel = false;

    public BizConfQueryApiProxy(IBizConfQueryApi bizConfQueryApi, BizConfQueryCacheProxy bizConfQueryCacheProxy) {
        this.bizConfQueryApi = bizConfQueryApi;
        this.bizConfQueryCacheProxy = bizConfQueryCacheProxy;
    }

    public static String spaceKey(ConfigQueryReq configQueryReq) {
        Long requestInstanceId = ServiceContext.getContext().getRequestInstanceId();
        if (requestInstanceId == null && configQueryReq.getBizIdContext() != null) {
            requestInstanceId = configQueryReq.getBizIdContext().getReqInstanceId();
            logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709instanceId,\u5c1d\u8bd5\u4f7f\u7528\u8bf7\u6c42\u4e2d\u7684instanceId:{}", (Object)requestInstanceId);
        }
        return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.SPACE.getValue(), requestInstanceId);
    }

    public static String tenantKey(ConfigQueryReq configQueryReq) {
        Long requestTenantId = ServiceContext.getContext().getRequestTenantId();
        if (requestTenantId == null && configQueryReq.getBizIdContext() != null) {
            requestTenantId = configQueryReq.getBizIdContext().getReqTenantId();
            logger.info("\u8bf7\u6c42header\u4e2d\u6ca1\u6709 tenantId ,\u5c1d\u8bd5\u4f7f\u7528\u8bf7\u6c42\u4e2d\u7684 tenantId :{}", (Object)requestTenantId);
        }
        return EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.TENANT.getValue(), requestTenantId);
    }

    public BizParamQueryResp queryRuntimeValueByCode(ConfigQueryReq configQueryReq) {
        BizParamQueryResp bizParamQueryResp;
        boolean fetchByLocalFirst;
        String idKey = EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.ID.getValue(), configQueryReq.getBidIdCode());
        String spaceKey = BizConfQueryApiProxy.spaceKey(configQueryReq);
        String tenantKey = BizConfQueryApiProxy.tenantKey(configQueryReq);
        String globalKey = EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.GLOBAL.getValue());
        boolean bl = fetchByLocalFirst = this.noBizIdModel || ServiceContext.getContext().getAttachment("FIRST_REQUEST_RANDOM_VALUE") != null;
        if (fetchByLocalFirst) {
            bizParamQueryResp = this.bizConfQueryCacheProxy.queryRuntimeValueByCode(idKey, spaceKey, tenantKey, globalKey, configQueryReq);
        } else {
            bizParamQueryResp = this.bizConfQueryCacheProxy.restQueryValue(configQueryReq);
            if (bizParamQueryResp != null) {
                if (CollectionUtils.isNotEmpty((Collection)bizParamQueryResp.getIdValues())) {
                    this.bizConfQueryCacheProxy.cacheIdValue(idKey, bizParamQueryResp);
                }
                if (CollectionUtils.isNotEmpty((Collection)bizParamQueryResp.getSpaceValues())) {
                    this.bizConfQueryCacheProxy.cacheSpaceValue(spaceKey, bizParamQueryResp);
                }
                if (CollectionUtils.isNotEmpty((Collection)bizParamQueryResp.getTenantValues())) {
                    this.bizConfQueryCacheProxy.cacheTenantValue(tenantKey, bizParamQueryResp);
                }
                this.bizConfQueryCacheProxy.cacheGlobalValue(globalKey, bizParamQueryResp);
            }
        }
        return bizParamQueryResp;
    }

    public BizExtImplQueryResp queryRuntimeImplByCode(ConfigQueryReq configQueryReq) {
        BizExtImplQueryResp bizExtImplQueryResp;
        boolean fetchByLocalFirst;
        String idKey = EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.ID.getValue(), configQueryReq.getBidIdCode());
        String spaceKey = BizConfQueryApiProxy.spaceKey(configQueryReq);
        String tenantKey = BizConfQueryApiProxy.tenantKey(configQueryReq);
        String globalKey = EnhanceConstants.combineKey(configQueryReq.getCode(), SettingLevelEnum.GLOBAL.getValue());
        boolean bl = fetchByLocalFirst = this.noBizIdModel || ServiceContext.getContext().getAttachment("FIRST_REQUEST_RANDOM_VALUE") != null;
        if (fetchByLocalFirst) {
            bizExtImplQueryResp = this.bizConfQueryCacheProxy.queryRuntimeImplByCode(idKey, spaceKey, tenantKey, globalKey, configQueryReq);
        } else {
            bizExtImplQueryResp = this.bizConfQueryCacheProxy.restQueryImpl(configQueryReq);
            if (bizExtImplQueryResp != null) {
                if (CollectionUtils.isNotEmpty((Collection)bizExtImplQueryResp.getIdValues())) {
                    this.bizConfQueryCacheProxy.cacheIdImpl(idKey, bizExtImplQueryResp);
                }
                if (CollectionUtils.isNotEmpty((Collection)bizExtImplQueryResp.getSpaceValues())) {
                    this.bizConfQueryCacheProxy.cacheSpaceImpl(spaceKey, bizExtImplQueryResp);
                }
                if (CollectionUtils.isNotEmpty((Collection)bizExtImplQueryResp.getTenantValues())) {
                    this.bizConfQueryCacheProxy.cacheTenantImpl(tenantKey, bizExtImplQueryResp);
                }
                this.bizConfQueryCacheProxy.cacheGlobalImpl(globalKey, bizExtImplQueryResp);
            }
        }
        return bizExtImplQueryResp;
    }
}

