/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.reader;

import com.dtyunxi.cube.starter.extension.config.SettingLocalCache;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizExtImplQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizParamQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.query.IBizConfQueryApi;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;

public class BizConfQueryCacheProxy {
    private final IBizConfQueryApi bizConfQueryApi;

    public BizConfQueryCacheProxy(IBizConfQueryApi bizConfQueryApi) {
        this.bizConfQueryApi = bizConfQueryApi;
    }

    @Caching(cacheable={@Cacheable(cacheNames={"idConfCache"}, key="#idKey", unless="#result?.bizCodeId == null || #result?.idValues?.size()==0"), @Cacheable(cacheNames={"spaceConfCache"}, key="#spaceKey", unless="#result?.spaceValues?.size()==0"), @Cacheable(cacheNames={"tenantConfCache"}, key="#tenantKey", unless="#result?.tenantValues?.size()==0"), @Cacheable(cacheNames={"globalConfCache"}, key="#globalKey", unless="#result?.globalValues?.size()==0")})
    public BizParamQueryResp queryRuntimeValueByCode(String idKey, String spaceKey, String tenantKey, String globalKey, ConfigQueryReq configQueryReq) {
        return this.restQueryValue(configQueryReq);
    }

    @Caching(cacheable={@Cacheable(cacheNames={"idConfCache"}, key="#idKey", unless="#result?.bizCodeId == null || #result?.idValues?.size()==0"), @Cacheable(cacheNames={"spaceConfCache"}, key="#spaceKey", unless="#result?.spaceValues?.size()==0"), @Cacheable(cacheNames={"tenantConfCache"}, key="#tenantKey", unless="#result?.tenantValues?.size()==0"), @Cacheable(cacheNames={"globalConfCache"}, key="#globalKey", unless="#result?.globalValues?.size()==0")})
    public BizExtImplQueryResp queryRuntimeImplByCode(String idKey, String spaceKey, String tenantKey, String globalKey, ConfigQueryReq configQueryReq) {
        return this.restQueryImpl(configQueryReq);
    }

    @Caching(put={@CachePut(cacheNames={"idConfCache"}, key="#idKey", condition="#value?.bizCodeId != null || #value?.idValues?.size()>0")})
    public BizParamQueryResp cacheIdValue(String idKey, BizParamQueryResp value) {
        return value;
    }

    @Caching(put={@CachePut(cacheNames={"spaceConfCache"}, key="#spaceKey", condition="#value?.spaceValues?.size()>0")})
    public BizParamQueryResp cacheSpaceValue(String spaceKey, BizParamQueryResp value) {
        return value;
    }

    @Caching(put={@CachePut(cacheNames={"tenantConfCache"}, key="#tenantKey", condition="#value?.tenantValues?.size()>0")})
    public BizParamQueryResp cacheTenantValue(String tenantKey, BizParamQueryResp value) {
        return value;
    }

    @Caching(put={@CachePut(cacheNames={"globalConfCache"}, key="#globalKey", condition="#value?.globalValues?.size()>0")})
    public BizParamQueryResp cacheGlobalValue(String globalKey, BizParamQueryResp value) {
        return value;
    }

    @Caching(put={@CachePut(cacheNames={"idConfCache"}, key="#idKey", condition="#impl?.bizCodeId != null || #impl?.idValues?.size()>0")})
    public BizExtImplQueryResp cacheIdImpl(String idKey, BizExtImplQueryResp impl) {
        return impl;
    }

    @Caching(put={@CachePut(cacheNames={"spaceConfCache"}, key="#spaceKey", condition="#impl?.spaceValues?.size()>0")})
    public BizExtImplQueryResp cacheSpaceImpl(String spaceKey, BizExtImplQueryResp impl) {
        return impl;
    }

    @Caching(put={@CachePut(cacheNames={"tenantConfCache"}, key="#tenantKey", condition="#impl?.tenantValues?.size()>0")})
    public BizExtImplQueryResp cacheTenantImpl(String tenantKey, BizExtImplQueryResp impl) {
        return impl;
    }

    @Caching(put={@CachePut(cacheNames={"globalConfCache"}, key="#globalKey", condition="#impl?.globalValues?.size()>0")})
    public BizExtImplQueryResp cacheGlobalImpl(String globalKey, BizExtImplQueryResp impl) {
        return impl;
    }

    public BizParamQueryResp restQueryValue(ConfigQueryReq configQueryReq) {
        RestResponse restResponse = this.bizConfQueryApi.queryRuntimeValueByCode(configQueryReq);
        if (restResponse.getData() != null) {
            SettingLocalCache.putIntoServiceContext(((BizParamQueryResp)restResponse.getData()).getBizCodeId());
        } else {
            SettingLocalCache.putIntoServiceContext(null);
        }
        return restResponse.getData() == null ? new BizParamQueryResp() : (BizParamQueryResp)restResponse.getData();
    }

    public BizExtImplQueryResp restQueryImpl(ConfigQueryReq configQueryReq) {
        RestResponse restResponse = this.bizConfQueryApi.queryRuntimeImplByCode(configQueryReq);
        if (restResponse.getData() != null) {
            SettingLocalCache.putIntoServiceContext(((BizExtImplQueryResp)restResponse.getData()).getBizCodeId());
        } else {
            SettingLocalCache.putIntoServiceContext(null);
        }
        return restResponse.getData() == null ? new BizExtImplQueryResp() : (BizExtImplQueryResp)restResponse.getData();
    }

    public static interface ICallBack {
    }
}

