/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.reader;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.dto.TimeSlotDto;
import com.dtyunxi.cube.enhance.param.ICubeParam;
import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.starter.extension.config.LocalConfValueProperties;
import com.dtyunxi.cube.starter.extension.reader.BizConfQueryApiProxy;
import com.dtyunxi.cube.starter.extension.reader.ConfValueConverter;
import com.dtyunxi.cube.starter.extension.reader.IConfReader;
import com.dtyunxi.cube.utils.Util;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizExtImplQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizParamQueryResp;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConfReader
implements ApplicationContextAware,
IConfReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfReader.class);
    private static final ThreadLocal<Map<String, Object>> CONF_THREAD_CACHE_BOX = ThreadLocal.withInitial(HashMap::new);
    private ApplicationContext applicationContext;
    private final BizConfQueryApiProxy bizConfQueryApiProxy;
    private final LocalConfValueProperties localConfValueProperties;
    private final boolean confReaderThrowError;

    public ConfReader(BizConfQueryApiProxy bizConfQueryApiProxy, LocalConfValueProperties localConfValueProperties, boolean confReaderThrowError) {
        this.bizConfQueryApiProxy = bizConfQueryApiProxy;
        this.localConfValueProperties = localConfValueProperties;
        this.confReaderThrowError = confReaderThrowError;
    }

    public static void cleanLocalCache() {
        CONF_THREAD_CACHE_BOX.remove();
    }

    private static <T> T getT(Class<?> valueClass, String respValue) {
        Object result = String.class == valueClass ? respValue : (Boolean.class == valueClass ? Boolean.valueOf(respValue) : (Integer.class == valueClass ? Integer.valueOf(respValue) : (Long.class == valueClass ? Long.valueOf(respValue) : (TimeSlotDto.class == valueClass ? ConfReader.getTimeSlot(respValue) : JacksonUtil.readValue((String)respValue, valueClass)))));
        return (T)result;
    }

    private static TimeSlotDto getTimeSlot(String timeSlot) {
        TimeSlotDto timeSlotDto = new TimeSlotDto();
        String[] times = timeSlot.split("-");
        if (times.length == 2) {
            timeSlotDto.setStartTime(times[0]);
            timeSlotDto.setEndTime(times[1]);
        }
        return timeSlotDto;
    }

    public boolean readBoolean(String paramCode, BizIdContext bizIdContext) {
        String respValue = this.readString(paramCode, bizIdContext);
        return respValue != null && (respValue.toLowerCase().equals("true") || respValue.equals("1"));
    }

    public int readInt(String paramCode, BizIdContext bizIdContext) {
        String respValue = this.readString(paramCode, bizIdContext);
        if (StringUtils.isNumeric((CharSequence)respValue)) {
            return Integer.parseInt(respValue);
        }
        return 0;
    }

    public long readLong(String paramCode, BizIdContext bizIdContext) {
        String respValue = this.readString(paramCode, bizIdContext);
        if (StringUtils.isNumeric((CharSequence)respValue)) {
            return Long.parseLong(respValue);
        }
        return 0L;
    }

    public BigDecimal readDecimal(String paramCode, BizIdContext bizIdContext) {
        String respValue = this.readString(paramCode, bizIdContext);
        if (respValue != null) {
            return new BigDecimal(respValue);
        }
        return null;
    }

    public String readString(String paramCode, BizIdContext bizIdContext) {
        ConfigQueryReq req = new ConfigQueryReq().setCode(paramCode).setBizIdContext(bizIdContext);
        BizParamQueryResp bizParamQueryResp = this.bizConfQueryApiProxy.queryRuntimeValueByCode(req);
        if (bizParamQueryResp != null) {
            logger.info("\u53c2\u6570:{} \u5bf9\u5e94\u7684\u4e1a\u52a1\u8eab\u4efd:{},\u503c:{}", new Object[]{paramCode, bizParamQueryResp.getBizCodeId(), bizParamQueryResp.getValue()});
            return (String)bizParamQueryResp.readValues().get(0);
        }
        if (this.confReaderThrowError) {
            throw new BizException("\u53c2\u6570" + paramCode + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u503c");
        }
        return null;
    }

    public <T> T read(Class<? extends ICubeParam<T>> codeClass, BizIdContext bizIdContext, String bizCode) {
        ConfValueConverter confValueConverter = respValues -> {
            ArrayList<Object> result = null;
            Type valueType = Util.readValueType((Class)codeClass);
            if (valueType instanceof ParameterizedType) {
                ParameterizedType valueClass = (ParameterizedType)valueType;
                Type[] actualTypeArguments = valueClass.getActualTypeArguments();
                if (actualTypeArguments == null || actualTypeArguments.length != 1) {
                    return null;
                }
                Type componentType = actualTypeArguments[0];
                ArrayList<Object> res = new ArrayList<Object>();
                for (String respValue : respValues) {
                    res.add(Util.getT((Class)((Class)componentType), (String)respValue));
                }
                result = res;
            } else if (respValues.size() == 1) {
                Class valueClass = (Class)valueType;
                String respValue = (String)respValues.get(0);
                result = Util.getT((Class)valueClass, (String)respValue);
            }
            return result;
        };
        return this.read(codeClass, bizIdContext, confValueConverter, bizCode);
    }

    private <T> void putThreadCache(String code, T result) {
        this.readCacheMap().put(code, result);
    }

    private <T> T readThreadCache(String code) {
        if (this.readCacheMap().containsKey(code)) {
            Object cacheValue = this.readCacheMap().get(code);
            logger.debug("\u4f7f\u7528\u7ebf\u7a0b\u7f13\u5b58,\u503c:{}", cacheValue);
            return (T)cacheValue;
        }
        return null;
    }

    private Map<String, Object> readCacheMap() {
        Map<String, Object> map = CONF_THREAD_CACHE_BOX.get();
        return map;
    }

    public <T> T read(Class<? extends ICubeParam<T>> codeClass, BizIdContext bizIdContext, @Nonnull ConfValueConverter<T> confValueConverter, String bizCode) {
        String confCode = this.packParamCode(codeClass);
        List<String> respValues = this.fetchBizParamValue(codeClass, bizIdContext, bizCode);
        Object result = CollectionUtils.isEmpty(respValues) ? null : confValueConverter.convert(respValues);
        this.putThreadCache(confCode, result);
        return (T)result;
    }

    private <T> List<String> fetchBizParamValue(Class<? extends ICubeParam<T>> codeClass, BizIdContext bizIdContext, String bizCode) {
        List<String> values;
        String paramCode = this.packParamCode(codeClass);
        ConfigQueryReq req = new ConfigQueryReq().setCode(paramCode).setBizIdContext(bizIdContext);
        if (StringUtils.isNotBlank((CharSequence)bizCode)) {
            req.setBidIdCode(bizCode);
        } else {
            Map bizObjs = (Map)ServiceContext.getContext().get("BIZ_ID_BIOS");
            if (bizObjs != null && bizObjs.size() > 0) {
                req.setBizObjs(JacksonUtil.toJson((Object)bizObjs));
            }
        }
        Integer confValueModel = this.localConfValueProperties.getObtainValueModel();
        if (confValueModel == 1) {
            List<String> values2 = this.parseLocalConfValue(paramCode, bizIdContext, bizCode);
            return CollectionUtils.isEmpty(values2) ? null : values2;
        }
        if (confValueModel == 2 && CollectionUtils.isNotEmpty(values = this.parseLocalConfValue(paramCode, bizIdContext, bizCode))) {
            return values;
        }
        BizParamQueryResp bizParamQueryResp = this.bizConfQueryApiProxy.queryRuntimeValueByCode(req);
        if (null == bizParamQueryResp) {
            if (this.confReaderThrowError) {
                throw new BizException("\u53c2\u6570" + paramCode + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u503c");
            }
            logger.info("\u53c2\u6570:{} \u5bf9\u5e94\u7684\u4e1a\u52a1\u8eab\u4efd:{},\u503c:{}", new Object[]{paramCode, null, null});
            return null;
        }
        List respValue = bizParamQueryResp.readValues();
        if (CollectionUtils.isEmpty((Collection)respValue) && this.confReaderThrowError) {
            throw new BizException("\u53c2\u6570" + paramCode + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u503c");
        }
        logger.info("\u53c2\u6570:{} \u5bf9\u5e94\u7684\u4e1a\u52a1\u8eab\u4efd:{},\u503c:{}", new Object[]{paramCode, bizParamQueryResp.getBizCodeId(), respValue});
        return respValue;
    }

    private <T> String packParamCode(Class<? extends ICubeParam<T>> codeClass) {
        return codeClass.getCanonicalName();
    }

    public <T> T readExtImpl(Class<T> type, BizIdContext bizIdContext) {
        String extCanonicalName = type.getCanonicalName();
        long bt = System.currentTimeMillis();
        List<String> implClasses = this.acquireImplCodes(bizIdContext, extCanonicalName);
        logger.debug("readExtImpl\u8bfb\u53d6\u914d\u7f6e\u9879\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - bt));
        if (CollectionUtils.isEmpty(implClasses)) {
            if (this.confReaderThrowError) {
                throw new BizException("\u6269\u5c55\u70b9" + extCanonicalName + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u5b9e\u73b0\u7c7b");
            }
            return null;
        }
        if (implClasses.size() > 1) {
            logger.warn("\u6269\u5c55\u70b9 {} \u671f\u5f85\u8fd4\u56de\u4e00\u4e2a\u5b9e\u73b0,\u5b9e\u9645\u8fd4\u56de\u591a\u4e2a,\u5c06\u53d6\u7b2c\u4e00\u4e2a\u503c:{}", (Object)extCanonicalName, implClasses);
        }
        String implClass = implClasses.get(0);
        T result = null;
        Map beans = this.applicationContext.getBeansOfType(type);
        for (Object value : beans.values()) {
            if (!AopProxyUtils.ultimateTargetClass(value).getCanonicalName().equals(implClass)) continue;
            result = (T)value;
            break;
        }
        if (result == null) {
            if (this.confReaderThrowError) {
                throw new BizException("applicationContext\u6839\u636e\u7c7b\u578b" + type + "\u627e\u4e0d\u5230\u5b9e\u73b0Bean[" + implClass + "]");
            }
            logger.warn("applicationContext\u6839\u636e\u7c7b\u578b{}\u627e\u4e0d\u5230\u5b9e\u73b0Bean[{}]", type, (Object)implClass);
        }
        this.putThreadCache(extCanonicalName, result);
        return result;
    }

    public <T> List<T> readListExtImpl(Class<T> type, BizIdContext bizIdContext) {
        String extCanonicalName = type.getCanonicalName();
        List<String> implClasses = this.acquireImplCodes(bizIdContext, extCanonicalName);
        if (CollectionUtils.isEmpty(implClasses)) {
            if (this.confReaderThrowError) {
                throw new BizException("\u6269\u5c55\u70b9" + extCanonicalName + "\u6ca1\u6709\u8bbe\u7f6e\u5bf9\u5e94\u5b9e\u73b0\u7c7b");
            }
            return new ArrayList();
        }
        ArrayList matchBeans = new ArrayList();
        Map beans = this.applicationContext.getBeansOfType(type);
        for (Object value : beans.values()) {
            if (!implClasses.contains(AopProxyUtils.ultimateTargetClass(value).getCanonicalName())) continue;
            matchBeans.add(value);
        }
        if (matchBeans.size() < implClasses.size()) {
            implClasses.removeAll(matchBeans.stream().map(e -> e.getClass().getCanonicalName()).collect(Collectors.toList()));
            if (this.confReaderThrowError) {
                throw new BizException("applicationContext\u6839\u636e\u7c7b\u578b" + type + "\u627e\u4e0d\u5230\u5b9e\u73b0Bean[" + StringUtils.join(implClasses, (String)",") + "]");
            }
            logger.warn("applicationContext\u6839\u636e\u7c7b\u578b{}\u627e\u4e0d\u5230\u5b9e\u73b0Bean[{}]", type, (Object)StringUtils.join(implClasses, (String)","));
        }
        this.putThreadCache(extCanonicalName, matchBeans);
        return matchBeans;
    }

    private List<String> acquireImplCodes(BizIdContext bizIdContext, String extCode) {
        List<String> values;
        String bizCode;
        ConfigQueryReq req = new ConfigQueryReq().setCode(extCode).setBizIdContext(bizIdContext);
        String string = bizCode = null == ServiceContext.getContext().get("BIZ_CODE") ? null : String.valueOf(ServiceContext.getContext().get("BIZ_CODE"));
        if (StringUtils.isNotBlank((CharSequence)bizCode)) {
            req.setBidIdCode(bizCode);
        } else {
            Map bizObjs = (Map)ServiceContext.getContext().get("BIZ_ID_BIOS");
            if (bizObjs != null && bizObjs.size() > 0) {
                req.setBizObjs(JacksonUtil.toJson((Object)bizObjs));
            }
        }
        Integer confValueModel = this.localConfValueProperties.getObtainValueModel();
        if (confValueModel == 1) {
            List<String> values2 = this.parseLocalConfValue(extCode, bizIdContext, bizCode);
            return CollectionUtils.isEmpty(values2) ? null : values2;
        }
        if (confValueModel == 2 && CollectionUtils.isNotEmpty(values = this.parseLocalConfValue(extCode, bizIdContext, bizCode))) {
            return values;
        }
        BizExtImplQueryResp bizExtImplQueryResp = this.bizConfQueryApiProxy.queryRuntimeImplByCode(req);
        List implClasses = null;
        if (bizExtImplQueryResp != null) {
            implClasses = bizExtImplQueryResp.readValues();
            logger.info("\u6269\u5c55\u70b9:{} \u5bf9\u5e94\u7684\u4e1a\u52a1\u8eab\u4efd:{},\u9700\u6267\u884c\u7684\u5b9e\u73b0:{}", new Object[]{extCode, bizExtImplQueryResp.getBizCodeId(), implClasses});
        }
        return implClasses;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private List<String> parseLocalConfValue(String confCode, BizIdContext bizIdContext, String bizId) {
        Long tenantId = bizIdContext.getReqTenantId();
        Long instanceId = bizIdContext.getReqInstanceId();
        List<LocalConfValueProperties.ConfValue> confs = this.localConfValueProperties.getConfs();
        Map<String, List<String>> conf2ValueMap = this.localConfValueProperties.getGlobal();
        if (CollectionUtils.isEmpty(confs) && (null == conf2ValueMap || conf2ValueMap.size() == 0)) {
            return null;
        }
        List<String> values = conf2ValueMap.get(confCode);
        if (CollectionUtils.isNotEmpty(values)) {
            return values;
        }
        if (CollectionUtils.isEmpty(confs)) {
            return null;
        }
        Map confValueMap = confs.stream().collect(Collectors.toMap(LocalConfValueProperties.ConfValue::getCode, Function.identity(), (k1, k2) -> k1));
        LocalConfValueProperties.ConfValue confValue = (LocalConfValueProperties.ConfValue)confValueMap.get(confCode);
        if (null == confValue) {
            return null;
        }
        List<String> global = confValue.getGlobal();
        Map<Long, List<String>> tenant = confValue.getTenant();
        Map<String, List<String>> bizSpace2Values = confValue.getBizSpace();
        Map<String, List<String>> bizId2Values = confValue.getBizId();
        if (StringUtils.isNotBlank((CharSequence)bizId)) {
            values = bizId2Values.get(bizId);
            if (CollectionUtils.isEmpty(values) && CollectionUtils.isEmpty(values = bizSpace2Values.get(instanceId.toString()))) {
                values = tenant.get(tenantId);
            }
            return CollectionUtils.isEmpty(values) ? global : values;
        }
        if (null != instanceId) {
            values = bizSpace2Values.get(instanceId.toString());
            if (CollectionUtils.isEmpty(values)) {
                values = tenant.get(tenantId);
            }
            return CollectionUtils.isEmpty(values) ? global : values;
        }
        if (null != tenantId) {
            values = tenant.get(tenantId);
            return CollectionUtils.isEmpty(values) ? global : values;
        }
        return global;
    }
}

