/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.config;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.rest.CubeSpringMvcContract;
import com.dtyunxi.huieryun.core.support.CustomDateSerializer;
import feign.QueryMapEncoder;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

@Configuration
public class SpringEnhanceConfig {
    private static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtils.isPrimitiveOrWrapper(clazz) || Temporal.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || URI.class == clazz || URL.class == clazz || Locale.class == clazz || Class.class == clazz;
    }

    public static List<Field> getDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    private static Map<String, Object> handle(String parentName, Object obj, int hierarchy) throws IllegalAccessException {
        if (hierarchy > 2) {
            throw new BizException("SpringQueryMap\u6ce8\u89e3\u4fee\u9970\u7684DTO\u5c5e\u6027\u5c42\u7ea7\u4e0d\u80fd\u8d85\u8fc73\u5c42");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Field> declaredFields = SpringEnhanceConfig.getDeclaredFields(obj.getClass());
        for (Field field : declaredFields) {
            String fieldName;
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            Object fieldVal = field.get(obj);
            if (fieldVal == null) continue;
            Class<?> fieldClazz = field.getType();
            String string = fieldName = parentName == null || parentName.isEmpty() ? field.getName() : parentName + "." + field.getName();
            if (SpringEnhanceConfig.isSimpleValueType(fieldClazz)) {
                if (fieldVal instanceof Date) {
                    fieldVal = CustomDateSerializer.instance.getCustomFormat().format(fieldVal);
                }
                params.put(fieldName, fieldVal);
                continue;
            }
            if (fieldClazz.isArray() && SpringEnhanceConfig.isSimpleValueType(fieldClazz.getComponentType())) {
                if (Array.getLength(fieldVal) <= 0) continue;
                params.put(fieldName, fieldVal);
                continue;
            }
            if (Collection.class.isAssignableFrom(fieldClazz)) {
                Collection collection = (Collection)fieldVal;
                Class elementType = CollectionUtils.findCommonElementType((Collection)collection);
                if (collection.size() <= 0 || elementType == null || !SpringEnhanceConfig.isSimpleValueType(elementType)) continue;
                params.put(fieldName, fieldVal);
                continue;
            }
            if (Map.class.isAssignableFrom(fieldClazz)) {
                Map map = (Map)fieldVal;
                map.forEach((key, value) -> params.put(SpringEnhanceConfig.mapKeyEncoder(fieldName, key), value));
                continue;
            }
            params.putAll(SpringEnhanceConfig.handle(fieldName, fieldVal, ++hierarchy));
        }
        return params;
    }

    private static String mapKeyEncoder(String fieldName, Object mapKey) {
        return String.format("%s%s%s%s", fieldName, "%5b", mapKey, "%5d");
    }

    @Bean
    @ConditionalOnMissingBean(name={"queryMapEncoder"})
    @ConditionalOnProperty(prefix="cube.enhance.query-map-encoder", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public QueryMapEncoder queryMapEncoder() {
        return object -> {
            if (object == null) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray() || Collection.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u5904\u7406\u4e0d\u652f\u6301\u6570\u7ec4\u6216\u8005\u96c6\u5408\u53c2\u6570");
            }
            try {
                return SpringEnhanceConfig.handle(null, object, 0);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("SpringQueryMap\u53c2\u6570\u5904\u7406\u51fa\u9519", e);
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"cubeSpringMvcContract"})
    @ConditionalOnProperty(prefix="cube.mvc.contract", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public CubeSpringMvcContract cubeSpringMvcContract() {
        return new CubeSpringMvcContract();
    }
}

